# -*- coding: utf-8
import logging

import os
from sandbox.projects.common import constants
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.nanny import nanny
from sandbox.common.types import client as ctc
import sandbox.projects.common.build.parameters as build_params
from sandbox import sdk2


class StartrekTicketIdsParameter(nanny.StartrekTicketIdsParameter):
    group = 'Other params'


logger = logging.getLogger(__name__)


class YT_CLOUD_ADAPTER(sdk2.Resource):
    auto_backup = True
    releasable = True
    executable = True
    releasers = ['YT', 'YT_ADMIN', 'YT_ROBOT']
    artifact = 'yt/admin/cloud_adapter/bin/server/server'


_RESOURCES = [YT_CLOUD_ADAPTER]
_BUILD_TARGETS = [
    'yt/admin/cloud_adapter',
]


class BuildYtCloudAdapter(nanny.ReleaseToNannyTask, YaMakeTask):
    """ Build YT lint service """
    type = 'BUILD_YT_CLOUD_ADAPTER'

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.ArcadiaPatch,
        build_params.BuildSystem,
        build_params.MakeContextOnDistbuild,
        build_params.BuildType,
        build_params.TestParameter,
        build_params.UseArcadiaApiFuse,
        build_params.AllowArcadiaApiFallback,
        StartrekTicketIdsParameter,
    ]

    disk_space = 8000
    client_tags = ctc.Tag.GENERIC
    ram = 4096
    cores = 24

    def initCtx(self):
        YaMakeTask.initCtx(self)
        self.on_save()

    def on_save(self):
        self.ctx[build_params.TestParameter.name] = True
        self.ctx[build_params.CheckoutModeParameter.name] = constants.CHECKOUT_MODE_MANUAL
        self.ctx[build_params.CheckoutParameter.name] = True

    def on_enqueue(self):
        YaMakeTask.on_enqueue(self)

    def get_build_type(self):
        return constants.RELEASE_WITH_DEBUG_INFO_BUILD_TYPE

    def get_targets(self):
        return _BUILD_TARGETS

    def get_resources(self):
        resources = {}
        for resource in _RESOURCES:
            result = {
                'description': resource.name,
                'resource_type': resource,
                'resource_path': os.path.basename(resource.artifact)
            }
            resources[resource.name] = result

        return resources

    def get_arts(self):
        result = []
        # Копирование происходит path -> os.path.join(artifacts_folder, dest, filename(path)
        # т.е. указание dest='' приводит к отсутствию дополнительного каталога dest
        for resource in _RESOURCES:
            result.append(
                {
                    'path': resource.artifact,
                    'dest': '',
                }
            )
        return result


__Task__ = BuildYtCloudAdapter
