import requests
from sandbox import sdk2
from sandbox import common


__all__ = ["YtClusters", "ArcadiaCheckoutTask"]


def get_secret(secret_owner, secret_name):
    try:
        secret_data = sdk2.Vault.data(secret_owner, secret_name)
    except common.errors.VaultError as error:
        raise common.errors.TaskFailure("Can't get secret '{}' with error: {}".format(secret_name, error))
    return secret_data


class YtClusters(object):
    @classmethod
    def get_config_json(cls):
        url = "https://locke.yt.yandex.net/api/v3/get"
        params = {"path": "//sys/clusters_config"}
        token = get_secret("YT_ROBOT", "YT_GET_CLUSTERS_TOKEN")
        headers = {"Authorization": "OAuth {}".format(token)}
        resp = requests.get(url, params=params, headers=headers)
        resp.raise_for_status()
        data = resp.json()
        return data

    @classmethod
    def get_clusters(cls, with_proxy=None):
        config = cls.get_config_json()
        if with_proxy:
            return sorted(
                [(c[0], c[1].get("proxy", "{}.yt.yandex.net".format(c[0]))) for c in config.items()],
                key=lambda x: x[0]
            )
        else:
            return sorted(config.keys())


class ArcadiaCheckoutTask(object):
    def __init__(self, url, dstdir, revision=None):
        self.url = url
        self.dstdir = dstdir
        self.revision = revision
