# coding: utf-8
from sandbox import sdk2


class YtReleaseableResource(sdk2.Resource):
    releasable = True
    releasers = ["YT", "YT_ADMIN", "rlipovsky"]


class YtPackageResource(YtReleaseableResource):
    branch = sdk2.parameters.String("Branch")
    build_type = sdk2.parameters.String("Build type")
    platform = sdk2.parameters.String("Platform")
    resource_name = sdk2.parameters.String("Resource name")
    resource_version = sdk2.parameters.String("Resource version")
    svn_path = sdk2.parameters.String("Svn path")
    svn_revision = sdk2.parameters.String("Svn revision")


class YtConfigResource(YtReleaseableResource):
    svn_revision = sdk2.parameters.String("Svn revision")


class YtConfigTool(sdk2.Resource):
    """
    YT Config generator tool
    """
    auto_backup = True
    releasable = True
    executable = True
    releasers = ['YT', 'YT_ADMIN', 'YT_ROBOT']
    arcadia_build_path = 'yt/admin/ytcfgen/bin/ytcfgen'
