# -*- coding: utf-8

import json
from sandbox import sdk2
from sandbox.sandboxsdk.svn import Arcadia


class YtBasicTask(sdk2.Task):
    def _get_path(self, subpath=""):
        """
        Get absolute path to subpath inside task dir
        :param str subpath: relative path inside task dir
        :return: str: absolute path
        """
        return "{}".format(self.path(subpath))

    def _arcadia_checkout(self, path, dstdir, revision=None):
        """
        Checkout 'path' from Arcadia to 'dstdir'
        :param str path: path inside arcadia after /arc/trunk/arcadia/
        :param str dstdir: checkout dst dir name
        :param str|String revision: svn revision number, if None revision is taken from svn.info
        :return str revision: Checked out revision id
        """
        url = Arcadia.trunk_url(path, revision)
        if not revision:
            revision = Arcadia.info(url)["entry_revision"]
        Arcadia.checkout(url, self._get_path(dstdir), revision=revision)
        return revision

    def _arcadia_export(self, path, dst, revision=None):
        url = Arcadia.trunk_url(path, revision)
        if not revision:
            revision = Arcadia.info(url)["entry_revision"]
        Arcadia.export(url, dst, revision)

    def _parse_arcadia_url(self, url):
        return Arcadia.parse_url(url)

    def _load_json(self, path_to_json):
        with open(self._get_path(path_to_json), "r") as fh:
            return json.load(fh)

    def _save_json(self, json_obj, config_name):
        with open(self._get_path(config_name), "w") as fh:
            json.dump(json_obj, fh, indent=4, sort_keys=True)
