# coding: utf-8
from sandbox.sdk2 import resource


class YT_BINARY(resource.AbstractResource):
    """
    """
    uploadable = True
    executable = True
    any_arch = False
    releasable = True
    auto_backup = True
    releasers = ["YT", "YT_ADMIN", "YT_ROBOT"]


class YT_PACKAGE(resource.AbstractResource):
    """
    """
    uploadable = True
    executable = False
    any_arch = False
    releasable = True
    auto_backup = True
    releasers = ["YT", "YT_ADMIN", "YT_ROBOT"]


class YT_YTSERVER_BASE(resource.AbstractResource):
    """
    """
    uploadable = True
    executable = True
    any_arch = False
    releasable = True
    auto_backup = True
    releasers = ["YP", "YT", "YT_ADMIN", "YT_ROBOT", "robot-srch-releaser"]


class YT_SCHEDULER(YT_YTSERVER_BASE):
    """
    ytserver-scheduler
    """


class YT_CLICKHOUSE(YT_YTSERVER_BASE):
    """
    ytserver-clickhouse
    """


class YT_MASTER(YT_YTSERVER_BASE):
    """
    ytserver-master
    """


class YT_JOB_PROXY(YT_YTSERVER_BASE):
    """
    ytserver-job-proxy
    """


class YT_CORE_FORWARDER(YT_YTSERVER_BASE):
    """
    ytserver-core-forwarder
    """


class YT_EXEC(YT_YTSERVER_BASE):
    """
    ytserver-exec
    """


class YT_NODE(YT_YTSERVER_BASE):
    """
    ytserver-node
    """


class YT_PROXY(YT_YTSERVER_BASE):
    """
    ytserver-proxy
    """


class YT_HTTP_PROXY(YT_YTSERVER_BASE):
    """
    ytserver-http-proxy
    """


class YT_ALL(YT_YTSERVER_BASE):
    """
    ytserver-all
    """


class YT_LOCAL_BIN(YT_YTSERVER_BASE):
    """
    yt_local
    """


class YT_NODE_MODULES(YT_YTSERVER_BASE):
    """
    ytserver-node_modules
    """


class YT_TOOLS(YT_YTSERVER_BASE):
    """
    ytserver-tools
    """


class YT_BINARIES(YT_YTSERVER_BASE):
    """
    yt binaries package
    """


class YP_MASTER(YT_YTSERVER_BASE):
    """
    ypserver-master
    """


class YT_SKYNET_MANAGER(YT_YTSERVER_BASE):
    """
    ytserver-skynet-manager
    """


class YT_SOLOMON_BRIDGE(YT_YTSERVER_BASE):
    """
    yt-solomon-bridge
    """


class YT_SOLOMON_RESOLVER(YT_YTSERVER_BASE):
    """
    yt-solomon-resolver
    """
