# coding: utf-8

from sandbox import sdk2
from sandbox.projects.resource_types import search_priemka_releasers

zephyr_releasers = search_priemka_releasers + ["robot-testenv"]


class ZephyrBinary(sdk2.Resource):
    """
    Zephyr model binary.
    """
    releasable = True
    any_arch = False
    releasers = zephyr_releasers
    auto_backup = True
    arcadia_build_path = 'search/zephyr/bin/zephyr'


class ZephyrServiceDiscoveryBinary(sdk2.Resource):
    """
    Zephyr model binary.
    """
    releasable = True
    any_arch = False
    releasers = zephyr_releasers
    auto_backup = True
    arcadia_build_path = 'search/zephyr/bin/sd/zephyr-discovery'


class ZephyrServalBinary(sdk2.Resource):
    """
    Serval binary.
    """
    releasable = True
    any_arch = False
    releasers = zephyr_releasers
    auto_backup = True
    arcadia_build_path = 'balancer/serval/serval'


class LogdumpBinary(sdk2.Resource):
    """
    Serval logdump binary.
    """
    releasable = True
    any_arch = False
    releasers = zephyr_releasers
    auto_backup = True
    arcadia_build_path = 'balancer/serval/tools/logdump/logdump'
