import logging
from sandbox.projects.zora.common import common
from sandbox.projects.zora.BuildZora2 import BuildZora2

from sandbox import sdk2

logger = logging.getLogger(__name__)


class BuildGoRotor(BuildZora2):

    class Parameters(BuildZora2.Parameters):
        with sdk2.parameters.CheckGroup("Resources to build") as build_targets:
            for r in sorted(common.GOROTOR_TARGETS):
                build_targets.values[r] = r

    def get_target_type(self, target):
        return common.GOROTOR_TARGETS[target]

    def get_target_name(self, target):
        return common.GOROTOR_TARGETS[target].name

    def get_target_bin_name(self, target):
        return common.GOROTOR_TARGETS[target].bin_name

    def get_target_res_type(self, target):
        return common.GOROTOR_TARGETS[target].res_type

    def get_target_arcadia_build_path(self, target):
        return common.GOROTOR_TARGETS[target].arcadia_build_path
