# coding: utf-8

import logging
import sandbox.projects.zora.resources as zora_resources

from sandbox import sdk2
from sandbox.sandboxsdk import sandboxapi
from sandbox.sandboxsdk import parameters
from sandbox.projects.zora.common.base_bin_build import BaseBuildZoraBins
from sandbox.projects.zora.common.base_bin_build import ZoraBinaries
from sandbox.projects.zora.common.base_bin_build import init


class BuildZoraTestResources(BaseBuildZoraBins):
    '''
    Binaries, configs and scripts for zora.
    '''

    type = 'BUILD_ZORA_TEST_RESOURCES'

    class Requirements(sdk2.Task.Requirements):
        disk_space = 60 * 1024

    class IncludeSvnConfigs(parameters.SandboxBoolParameter):
        name = 'include_svn_configs'
        description = 'configs'
        default_value = True
        group = 'Zora Files'

    class ReleaseToNanny(parameters.SandboxRadioParameter):
        choices = [(_, _) for _ in ('none', sandboxapi.RELEASE_TESTING)]
        description = "Release to Nanny."
        default_value = 'none'
        name = 'release_to_nanny'
        group = 'After Build Actions'

    TARGET_RESOURCES = (
    )

    input_parameters, enabled_builds = init(TARGET_RESOURCES, [ZoraBinaries])
    input_parameters = input_parameters + [IncludeSvnConfigs,
                                           ReleaseToNanny]

    def on_execute(self):
        BaseBuildZoraBins.on_execute(self)

        if self.ctx['include_svn_configs']:
            self._create_svn_resource('robot/zora/conf', 'svn_configs.tar.gz', zora_resources.ZoraSvnConfigs)

        if self.ctx['release_to_nanny'] != 'none':

            check_already_released = False

            releaser_task = self.create_subtask(
                task_type='RELEASE_ANY',
                input_parameters={
                    'check_already_released': check_already_released,
                    'release_task_id': self.id,
                    'release_status': self.ctx['release_to_nanny'],
                },
                description="Zora binaries (task id: {}) auto release. Revision: {}".format(str(self.id), self.ctx.get('arcadia_revision'))
            )
            logging.debug("Subtask {} runned, waiting for it's result.\n\n".format(releaser_task.id))


__Task__ = BuildZoraTestResources
