# coding: utf-8
import sandbox.projects.zora.resources as zora_resources

from sandbox.projects.zora.common.base_bin_build import BaseBuildZoraBins
from sandbox.projects.zora.common.base_bin_build import init

import logging


class RestartRotorNewService(BaseBuildZoraBins):
    '''
    Task for rotor-scheduler and rotor-executor service restrart
    '''

    type = 'RESTART_ROTOR_NEW_SERVICE'

    input_parameters, enabled_builds = init(tuple(), [])

    def on_execute(self):
        BaseBuildZoraBins.on_execute(self)
        self._create_svn_resource('robot/uzor/conf/conf-lemur-prod/empty', 'useless.tar.gz', zora_resources.RotorNewRestartResource)

        check_already_released = False

        releaser_task = self.create_subtask(
            task_type='RELEASE_ANY',
            input_parameters={
                'check_already_released': check_already_released,
                'release_task_id': self.id,
                'release_status': 'stable',
            },
            description="Rotor restart (task id: {})".format(str(self.id))
        )
        logging.debug("Subtask {} runned, waiting for it's result.\n\n".format(releaser_task.id))

__Task__ = RestartRotorNewService
