from sandbox.projects.zora import resources

ZORA_TARGETS = {
    resources.ZoraBinary.name: resources.ZoraBinary,
    resources.GateBinary.name: resources.GateBinary,
    resources.SpiderBinary.name: resources.SpiderBinary,
    resources.SpiderNewBinary.name: resources.SpiderNewBinary,
    resources.FetcherBinary.name: resources.FetcherBinary,
    resources.FetcherNewBinary.name: resources.FetcherNewBinary,
    resources.LogsubsBinary.name: resources.LogsubsBinary,
    resources.PdfetchBinary.name: resources.PdfetchBinary,
    resources.ZoraClientBinary.name: resources.ZoraClientBinary,
    resources.ZoraMapIpsBinary.name: resources.ZoraMapIpsBinary,
    resources.ZoraNat64TranslatorBinary.name: resources.ZoraNat64TranslatorBinary,
    resources.RotorHttpBinary.name: resources.RotorHttpBinary,
    resources.RotorCacheBinary.name: resources.RotorCacheBinary,
    resources.RotorProxyBinary.name: resources.RotorProxyBinary,
    resources.RotorExecutorNewBinary.name: resources.RotorExecutorNewBinary,
    resources.PdfetchParsePageBinary.name: resources.PdfetchParsePageBinary,
    resources.ZoraConfChecker.name: resources.ZoraConfChecker,
    resources.ZoraLoadGeneratorBinary.name: resources.ZoraLoadGeneratorBinary,
    resources.ZoraConfigs.name: resources.ZoraConfigs,
    resources.ZoraDynamicConfigs.name: resources.ZoraDynamicConfigs,
    resources.ZoraPostprocessing.name: resources.ZoraPostprocessing,
    resources.GorotorConfigs.name: resources.GorotorConfigs,
    resources.GorotorDynamicConfigs.name: resources.GorotorDynamicConfigs,
    resources.LsofMonitorBinary.name: resources.LsofMonitorBinary,
    resources.RotorCacheNewBinary.name: resources.RotorCacheNewBinary,
    resources.RotorPsychoKiller.name: resources.RotorPsychoKiller,
}


GOZORA_TARGETS = {
    resources.GoZoraBinary.name: resources.GoZoraBinary,
    resources.GoZoraConfigs.name: resources.GoZoraConfigs,
    resources.GoZoraScripts.name: resources.GoZoraScripts,
}


GOROTOR_TARGETS = {
    resources.ZoraBinary.name: resources.ZoraBinary,
    resources.GateBinary.name: resources.GateBinary,
    resources.RotorHttpBinary.name: resources.RotorHttpBinary,
    resources.RotorProxyBinary.name: resources.RotorProxyBinary,
    resources.RotorExecutorNewBinary.name: resources.RotorExecutorNewBinary,
    resources.GorotorConfigs.name: resources.GorotorConfigs,
    resources.GorotorDynamicConfigs.name: resources.GorotorDynamicConfigs,
}


_ZORA_TARGETS = {
    # Common resources
    resources.ZoraBinary.name: {
        'build_path': resources.ZoraBinary.arcadia_build_path,
        'bin_name': resources.ZoraBinary.bin_name,
        'res_type': resources.ZoraBinary.type,
        'type': 'build',
        'zora_type': 'common'
    },
    resources.GateBinary.name: {
        'build_path': resources.GateBinary.arcadia_build_path,
        'bin_name': resources.GateBinary.bin_name,
        'res_type': resources.GateBinary.type,
        'type': 'build',
        'zora_type': 'common'
    },
    resources.SpiderBinary.name: {
        'build_path': resources.SpiderBinary.arcadia_build_path,
        'bin_name': resources.SpiderBinary.bin_name,
        'res_type': resources.SpiderBinary.type,
        'type': 'build',
        'zora_type': 'common'
    },
    resources.SpiderNewBinary.name: {
        'build_path': resources.SpiderNewBinary.arcadia_build_path,
        'bin_name': resources.SpiderNewBinary.bin_name,
        'res_type': resources.SpiderNewBinary.type,
        'type': 'build',
        'zora_type': 'common'
    },
    resources.FetcherBinary.name: {
        'build_path': resources.FetcherBinary.arcadia_build_path,
        'bin_name': resources.FetcherBinary.bin_name,
        'res_type': resources.FetcherBinary.type,
        'type': 'build',
        'zora_type': 'common'
    },
    resources.FetcherNewBinary.name: {
        'build_path': resources.FetcherNewBinary.arcadia_build_path,
        'bin_name': resources.FetcherNewBinary.bin_name,
        'res_type': resources.FetcherNewBinary.type,
        'type': 'build',
        'zora_type': 'common'
    },
    resources.LogsubsBinary.name: {
        'build_path': resources.LogsubsBinary.arcadia_build_path,
        'bin_name': resources.LogsubsBinary.bin_name,
        'res_type': resources.LogsubsBinary.type,
        'type': 'build',
        'zora_type': 'common'
    },
    resources.PdfetchBinary.name: {
        'build_path': resources.PdfetchBinary.arcadia_build_path,
        'bin_name': resources.PdfetchBinary.bin_name,
        'res_type': resources.PdfetchBinary.type,
        'type': 'build',
        'zora_type': 'common'
    },
    resources.ZoraClientBinary.name: {
        'build_path': resources.ZoraClientBinary.arcadia_build_path,
        'bin_name': resources.ZoraClientBinary.bin_name,
        'res_type': resources.ZoraClientBinary.type,
        'type': 'build',
        'zora_type': 'common'
    },
    resources.ZoraMapIpsBinary.name: {
        'build_path': resources.ZoraMapIpsBinary.arcadia_build_path,
        'bin_name': resources.ZoraMapIpsBinary.bin_name,
        'res_type': resources.ZoraMapIpsBinary.type,
        'type': 'build',
        'zora_type': 'common'
    },
    resources.ZoraNat64TranslatorBinary.name: {
        'build_path': resources.ZoraNat64TranslatorBinary.arcadia_build_path,
        'bin_name': resources.ZoraNat64TranslatorBinary.bin_name,
        'res_type': resources.ZoraNat64TranslatorBinary.type,
        'type': 'build',
        'zora_type': 'common'
    },
    resources.RotorHttpBinary.name: {
        'build_path': resources.RotorHttpBinary.arcadia_build_path,
        'bin_name': resources.RotorHttpBinary.bin_name,
        'res_type': resources.RotorHttpBinary.type,
        'type': 'build',
        'zora_type': 'common'
    },
    # Zora offline specific resources
    resources.ZoraConfigs.name: {
        'build_path': resources.ZoraConfigs.arcadia_build_path,
        'res_type': resources.ZoraConfigs.type,
        'type': 'vcs',
        'zora_type': 'zora'
    },
    resources.ZoraDynamicConfigs.name: {
        'build_path': resources.ZoraDynamicConfigs.arcadia_build_path,
        'res_type': resources.ZoraDynamicConfigs.type,
        'type': 'vcs',
        'zora_type': 'zora'
    },
    resources.ZoraPostprocessing.name: {
        'build_path': resources.ZoraPostprocessing.arcadia_build_path,
        'res_type': resources.ZoraPostprocessing.type,
        'type': 'package',
        'zora_type': 'zora'
    },
    # Zora Online specific resources
    resources.ZoraOnlineConfigs.name: {
        'build_path': resources.ZoraOnlineConfigs.arcadia_build_path,
        'res_type': resources.ZoraOnlineConfigs.type,
        'type': 'vcs',
        'zora_type': 'zora_online'
    },
    resources.ZoraOnlineDynamicConfigs.name: {
        'build_path': resources.ZoraOnlineDynamicConfigs.arcadia_build_path,
        'res_type': resources.ZoraOnlineDynamicConfigs.type,
        'type': 'vcs',
        'zora_type': 'zora_online'
    },
    resources.ZoraOnlinePostprocessing.name: {
        'build_path': resources.ZoraOnlinePostprocessing.arcadia_build_path,
        'type': 'package',
        'zora_type': 'zora_online'
    },
    # Gorotor
    resources.GorotorConfigs.name: {
        'build_path': resources.GorotorConfigs.arcadia_build_path,
        'res_type': resources.GorotorConfigs.type,
        'type': 'vcs',
        'zora_type': 'zora'
    },
    resources.GorotorDynamicConfigs.name: {
        'build_path': resources.GorotorDynamicConfigs.arcadia_build_path,
        'res_type': resources.GorotorDynamicConfigs.type,
        'type': 'vcs',
        'zora_type': 'zora'
    },
    # Rotor specific resources
    resources.RotorCacheBinary.name: {
        'build_path': resources.RotorCacheBinary.arcadia_build_path,
        'bin_name': resources.RotorCacheBinary.bin_name,
        'res_type': resources.RotorCacheBinary.type,
        'type': 'build',
        'zora_type': 'zora'
    },
    resources.RotorProxyBinary.name: {
        'build_path': resources.RotorProxyBinary.arcadia_build_path,
        'bin_name': resources.RotorProxyBinary.bin_name,
        'res_type': resources.RotorProxyBinary.type,
        'type': 'build',
        'zora_type': 'zora'
    },
    resources.RotorBalancerBinary.name: {
        'build_path': resources.RotorBalancerBinary.arcadia_build_path,
        'type': 'build',
        'zora_type': 'zora'
    },
    resources.RotorRegistryBinary.name: {
        'build_path': resources.RotorRegistryBinary.arcadia_build_path,
        'bin_name': resources.RotorRegistryBinary.bin_name,
        'res_type': resources.RotorRegistryBinary.type,
        'type': 'build',
        'zora_type': 'zora'
    },
    resources.RotorExecutorBinary.name: {
        'build_path': resources.RotorExecutorBinary.arcadia_build_path,
        'bin_name': resources.RotorExecutorBinary.bin_name,
        'res_type': resources.RotorExecutorBinary.type,
        'type': 'build',
        'zora_type': 'zora'
    },
    resources.RotorExecutorNewBinary.name: {
        'build_path': resources.RotorExecutorNewBinary.arcadia_build_path,
        'bin_name': resources.RotorExecutorNewBinary.bin_name,
        'res_type': resources.RotorExecutorNewBinary.type,
        'type': 'build',
        'zora_type': 'zora'
    },
    resources.RotorSchedulerBinary.name: {
        'build_path': resources.RotorSchedulerBinary.arcadia_build_path,
        'bin_name': resources.RotorSchedulerBinary.bin_name,
        'res_type': resources.RotorSchedulerBinary.type,
        'type': 'build',
        'zora_type': 'zora'
    },
    resources.PdfetchParsePageBinary.name: {
        'build_path': resources.PdfetchParsePageBinary.arcadia_build_path,
        'bin_name': resources.PdfetchParsePageBinary.bin_name,
        'res_type': resources.PdfetchParsePageBinary.type,
        'type': 'build',
        'zora_type': 'common'
    },
    resources.ZoraConfChecker.name: {
        'build_path': resources.ZoraConfChecker.arcadia_build_path,
        'bin_name': resources.ZoraConfChecker.bin_name,
        'res_type': resources.ZoraConfChecker.type,
        'type': 'build',
        'zora_type': 'common'
    },
    resources.ZoraLoadGeneratorBinary.name: {
        'build_path': resources.ZoraLoadGeneratorBinary.arcadia_build_path,
        'bin_name': resources.ZoraLoadGeneratorBinary.bin_name,
        'res_type': resources.ZoraLoadGeneratorBinary.type,
        'type': 'build',
        'zora_type': 'common'
    },
    resources.LsofMonitorBinary.name: {
        'build_path': resources.LsofMonitorBinary.arcadia_build_path,
        'bin_name': resources.LsofMonitorBinary.bin_name,
        'res_type': resources.LsofMonitorBinary.type,
        'type': 'build',
        'zora_type': 'zora'
    },
    resources.RotorCacheNewBinary.name: {
        'build_path': resources.RotorCacheNewBinary.arcadia_build_path,
        'bin_name': resources.RotorCacheNewBinary.bin_name,
        'res_type': resources.RotorCacheNewBinary.type,
        'type': 'build',
        'zora_type': 'zora'
    },
    resources.RotorPsychoKiller.name: {
        'build_path': resources.RotorPsychoKiller.arcadia_build_path,
        'bin_name': resources.RotorPsychoKiller.bin_name,
        'res_type': resources.RotorPsychoKiller.type,
        'type': 'build',
        'zora_type': 'zora'
    }
}
