from sandbox import sdk2

zora_releasers = [
    'izetag',
    'robot-rthub',
    'robot-testenv',
    'zagevalo',
    'vlavrenchenko',
    'antervis',
    'gous32',
    'robot-zora',
    'zenoyan',
    'andreytert',
    'akhovrychev',
    'abogutskiy',
    'meow',
    'mvtomilov',
    'alex-stanovoy',
    'slobodetskiy',
    'oddeye'
]

zora_subscribers = ['zora_releasers']


class ZoraBindPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class ZoraPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class ZoraConfigsPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class ZoraDynamicConfigsPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class ZoraOnlinePackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class ZoraOnlineConfigsPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class ZoraOnlineDynamicConfigsPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class ZoraOnlinePostprocessingPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class ZoraPostprocessingPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class ZoraBinaryPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class ZoraMasterCmPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class ZoraCmPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class PortoLayerBind(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers


class FetcherFirewallConfig(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = False
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = None


class ZoraClusterConfig(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = False
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = None


class ZoraTestClusterConfig(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = False
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = None


class ZoraOnlineClusterConfig(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = False
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = None


class ZoraOnlineDevClusterConfig(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = False
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = None


class ZoraSvnConfigs(sdk2.Resource):
    releasable = True
    executable = False
    releasers = zora_releasers


class ZoraLocalExternalConfigs(sdk2.Resource):
    """ Dir with files required for local Zora that are not presented in svn """


class RotorPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class RotorExecutorPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class RotorViewerPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class RotorRestartResource(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class RotorNewRestartResource(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class RthubRestartResource(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class ClusterConfGeneratorBin(sdk2.Resource):
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = False


class ZoraHostSettingsData(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class PdfetchOnlinePackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class PdfetchPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class PdfetchExternalFiles(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class ZoraBinary(sdk2.Resource):
    name = 'ZORA_BINARY'
    any_arch = False
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'zora/zora/bin'
    bin_name = 'zora'
    res_type = 'build'


class GateBinary(sdk2.Resource):
    name = 'GATE_BINARY'
    any_arch = False
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/gate/bin'
    bin_name = 'gate'
    res_type = 'build'


class SpiderBinary(sdk2.Resource):
    name = 'SPIDER_BINARY'
    any_arch = False
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'zora/spider/bin'
    bin_name = 'spider'
    res_type = 'build'


class SpiderNewBinary(sdk2.Resource):
    name = 'SPIDER_NEW_BINARY'
    any_arch = False
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/spider/bin'
    bin_name = 'spider_new'
    res_type = 'build'


class FetcherBinary(sdk2.Resource):
    name = 'FETCHER_BINARY'
    any_arch = False
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'yweb/robot/fetcher/fetcher'
    bin_name = 'fetcher'
    res_type = 'build'


class FetcherNewBinary(sdk2.Resource):
    name = 'FETCHER_NEW_BINARY'
    any_arch = False
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/fetcher/bin'
    bin_name = 'fetcher_new'
    res_type = 'build'


class PdfetchBinary(sdk2.Resource):
    name = 'PDFETCH_BINARY'
    any_arch = False
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'zora/pdfetch/bin'
    bin_name = 'pdfetch'
    res_type = 'build'


class LogsubsBinary(sdk2.Resource):
    name = 'LOGSUBS_BINARY'
    any_arch = False
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'zora/logsubs'
    bin_name = 'logsubs'
    res_type = 'build'


class ZoraClientBinary(sdk2.Resource):
    name = 'ZORA_CLIENT_BINARY'
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'zora/client/main'
    bin_name = 'zoracl'
    res_type = 'build'


class ZoraMapIpsBinary(sdk2.Resource):
    name = 'ZORA_MAP_IPS_BINARY'
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/scripts/map_zora_ips'
    bin_name = 'map_zora_ips'
    res_type = 'build'


class ZoraNat64TranslatorBinary(sdk2.Resource):
    name = 'ZORA_NAT64_TRANSLATOR_BINARY'
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/tools/nat64_translator'
    bin_name = 'nat64_translator'
    res_type = 'build'


class ZoraLoadGeneratorBinary(sdk2.Resource):
    name = 'ZORA_LOAD_GENERATOR_BINARY'
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/load_generator'
    bin_name = 'load_generator'
    res_type = 'build'


class ZoraHostsSettingsData(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = False
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = None


class ZoraConfigs(sdk2.Resource):
    name = 'ZORA_CONFIGS'
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/conf/static/cloud;robot/zora/conf/common'
    res_type = 'vcs'


class ZoraOnlineConfigs(sdk2.Resource):
    name = 'ZORA_ONLINE_CONFIGS'
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/conf/static/online;robot/zora/conf/common'
    res_type = 'vcs'


class ZoraDynamicConfigs(sdk2.Resource):
    name = 'ZORA_DYNAMIC_CONFIGS'
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/conf/dynamic/cloud'
    res_type = 'vcs'


class ZoraOnlineDynamicConfigs(sdk2.Resource):
    name = 'ZORA_ONLINE_DYNAMIC_CONFIGS'
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/conf/dynamic/online'
    res_type = 'vcs'


class GorotorConfigs(sdk2.Resource):
    name = 'GOROTOR_CONFIGS'
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/conf/static/gorotor;robot/zora/conf/common'
    res_type = 'vcs'


class GorotorDynamicConfigs(sdk2.Resource):
    name = 'GOROTOR_DYNAMIC_CONFIGS'
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/conf/dynamic/gorotor'
    res_type = 'vcs'


class ZoraPostprocessing(sdk2.Resource):
    name = 'ZORA_POSTPROCESSING'
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/packages/zora_postprocessing_package.json'
    res_type = 'package'


class ZoraOnlinePostprocessing(sdk2.Resource):
    name = 'ZORA_ONLINE_POSTPROCESSING'
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/packages/zora_postprocessing_package.json'


class ZoraPushClient(sdk2.Resource):
    name = 'ZORA_PUSH_CLIENT'
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/push-client'


class RotorHttpBinary(sdk2.Resource):
    name = 'ROTOR_HTTP_BINARY'
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'yweb/robot/js/rotor/bin/http'
    bin_name = 'rotor-http'
    res_type = 'build'


class RotorBalancerBinary(sdk2.Resource):
    name = 'ROTOR_BALANCER_BINARY'
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'yweb/robot/js/rotor/bin/balancer'
    bin_name = 'rotor-balancer'
    res_type = 'build'


class RotorCacheBinary(sdk2.Resource):
    name = 'ROTOR_CACHE_BINARY'
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'yweb/robot/js/rotor/bin/cache'
    bin_name = 'rotor-cache'
    res_type = 'build'


class RotorProxyBinary(sdk2.Resource):
    name = 'ROTOR_PROXY_BINARY'
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'yweb/robot/js/rotor/bin/proxy'
    bin_name = 'rotor-proxy'
    res_type = 'build'


class RotorSchedulerBinary(sdk2.Resource):
    name = 'ROTOR_SCHEDULER_BINARY'
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'yweb/robot/js/rotor/bin/scheduler'
    bin_name = 'rotor-scheduler'
    res_type = 'build'


class RotorRegistryBinary(sdk2.Resource):
    name = 'ROTOR_REGISTRY_BINARY'
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'zora/cluster/registry/app'
    bin_name = 'registry'
    res_type = 'build'


class RotorExecutorBinary(sdk2.Resource):
    name = 'ROTOR_EXECUTOR_BINARY'
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'yweb/robot/js/rotor/bin/executor'
    bin_name = 'rotor-executor'
    res_type = 'build'


class RotorExecutorNewBinary(sdk2.Resource):
    name = 'ROTOR_EXECUTOR_NEW_BINARY'
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'yweb/robot/js/rotor/executor_new/server'
    bin_name = 'executor'
    res_type = 'build'


class RotorBlink(sdk2.Resource):
    name = 'ROTOR_BLINK'
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers


class PdfetchParsePageBinary(sdk2.Resource):
    name = 'PDFETCH_PARSEPAGE_BINARY'
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'yweb/webscripts/video/metarobot/parsepage/tool/bin'
    bin_name = 'parsepage'
    res_type = 'build'


class ZoraConfChecker(sdk2.Resource):
    name = 'ZORA_CONF_CHECKER'
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/tools/conf_checker'
    bin_name = 'conf_checker'
    res_type = 'build'


class GoZoraBinary(sdk2.Resource):
    name = 'GOZORA_BINARY'
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/gozora/cmd'
    bin_name = 'gozora'
    res_type = 'build'


class GoZoraConfigs(sdk2.Resource):
    name = 'GOZORA_CONFIGS'
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/gozora/conf'
    res_type = 'vcs'


class GoZoraScripts(sdk2.Resource):
    name = 'GOZORA_SCRIPTS'
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/gozora/scripts'
    res_type = 'vcs'


class DnsProxyBinary(sdk2.Resource):
    name = 'DNS_PROXY_BINARY'
    any_arch = False
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/tools/dns_proxy/main'
    bin_name = 'zora_dns_proxy'
    res_type = 'build'


class HitrenimalsPreProcBinary(sdk2.Resource):
    name = 'HITRENIMALS_PRE_PROC_BINARY'
    any_arch = False
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/tools/hitrenimals_pp'
    bin_name = 'hitrenimals_pp'
    res_type = 'build'


class LsofMonitorBinary(sdk2.Resource):
    name = 'LSOF_MONITOR_BINARY'
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/tools/lsof_monitor'
    bin_name = 'lsof_monitor'
    res_type = 'build'


class ZoraSalmonAgentBinary(sdk2.Resource):
    name = 'ZORA_SALMON_AGENT_BINARY'
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/tools/salmon_agent'
    bin_name = 'salmon_agent'
    res_type = 'build'


class RotorCacheNewBinary(sdk2.Resource):
    name = 'ROTOR_CACHE_NEW_BINARY'
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/rotor/cache/bin'
    bin_name = 'cache'
    res_type = 'build'


class RotorPsychoKiller(sdk2.Resource):
    name = 'ROTOR_PSYCHO_KILLER'
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = zora_releasers
    release_subscribers = zora_subscribers
    arcadia_build_path = 'robot/zora/tools/rotor_psychokiller'
    bin_name = 'psycho_killer'
    res_type = 'build'
