#!/usr/bin/env python

from __future__ import absolute_import

import os
import sys


def main(service_root):
    import sandbox.proxy.daemon
    conf = sandbox.proxy.daemon.Registry().server
    dbg = conf.debug
    dbg.venv = dbg.venv or os.path.dirname(os.path.dirname(sys.executable))
    uwsgi = os.path.join(dbg.venv, "bin", "uwsgi")
    cmd = [
        "uwsgi",
        "--shared-socket", ":".join([dbg.host, str(dbg.port)]),
        "--http-socket", "=0",
        "--chunked-input-limit", str(100 << 20),
        "--http-chunked-input",
        "--chunked-input-timeout", "21600",
        "--processes", "2",
        "--threads", "2",
        "--hook-as-user-atexit", "print:goodbye cruel world",
        "--die-on-term",
        "--virtualenv", dbg.venv,
        "--wsgi-file", __file__,
        "--callable", "application",
        "--sharedarea", "200",
        "--log-format", " ".join([
            '[%(ltime)] %(remote_ip) %(user)',
            '"%(method) %(uri) %(proto)" %(status) %(hsize)+%(rsize)',
            '"%(referer)" "%(uagent)" %(msecs)ms [pid: %(pid)|wid: %(wid)|rid: %(rid)]',
        ]),
        "--websocket-pong-tolerance", "30",
        "--enable-metrics",
        "--metrics-no-cores",
        "--metric", "name=http_200,type=counter",
        "--metric", "name=http_201,type=counter",
        "--metric", "name=http_202,type=counter",
        "--metric", "name=http_307,type=counter",
        "--metric", "name=http_400,type=counter",
        "--metric", "name=http_401,type=counter",
        "--metric", "name=http_404,type=counter",
        "--metric", "name=http_405,type=counter",
        "--metric", "name=http_410,type=counter",
        "--metric", "name=http_413,type=counter",
        "--metric", "name=http_500,type=counter",
        "--metric", "name=http_503,type=counter",
        "--metric", "name=http_503,type=counter",
        "--metric", "name=http_OTHER,type=counter",
    ]

    for cache in conf.cache:
        params = []
        for k, v in conf.cache[cache].iteritems():
            if k in ("expires",):
                continue
            params.append((k, v))
        cmd.append("--cache2")
        cmd.append(",".join("{}={}".format(k, v) for k, v in params))

    if dbg.ssl.port:
        cmd[5:0] = [
            "--shared-socket", ":".join([dbg.host, str(dbg.ssl.port)]),
            "--https-socket", ",".join(["=1", dbg.ssl.crt, dbg.ssl.key]),
        ]
    if dbg.stats:
        cmd.extend(["--stats", dbg.stats])
    print("Running standalone uwsgi application with command {!r}".format(cmd))
    os.execv(uwsgi, cmd)


if __name__ == "__main__":
    # Add service root to the libraries lookup path
    service_root = os.path.realpath(__file__)
    for _ in xrange(4):
        service_root = os.path.dirname(service_root)
    os.environ["PYTHONPATH"] = ":".join(os.environ.get("PYTHONPATH", "").split(":") + [service_root])
    sys.path.insert(0, service_root)
    sys.exit(main(service_root))
else:
    import sandbox.proxy.daemon
    application = sandbox.proxy.daemon.Application(True)
