import logging

_logger = logging.getLogger()
_traceEnabled = False

__all__ = ["enableTrace", "dump", "error", "debug", "trace",
           "isEnabledForError", "isEnabledForDebug"]


def enableTrace(tracable):
    """
    turn on/off the tracability.

    tracable: boolean value. if set True, tracability is enabled.
    """
    global _traceEnabled
    _traceEnabled = tracable
    if tracable:
        if not _logger.handlers:
            _logger.addHandler(logging.StreamHandler())
        _logger.setLevel(logging.DEBUG)


def dump(title, message):
    if _traceEnabled:
        _logger.debug("--- " + title + " ---")
        _logger.debug(message)
        _logger.debug("-----------------------")


def error(msg):
    _logger.error(msg)


def debug(msg):
    _logger.debug(msg)


def trace(msg):
    if _traceEnabled:
        _logger.debug(msg)


def isEnabledForError():
    return _logger.isEnabledFor(logging.ERROR)


def isEnabledForDebug():
    return _logger.isEnabledFor(logging.DEBUG)
