PY3_PROGRAM(proxy)

OWNER(g:sandbox-dev)

PEERDIR(
    contrib/python/aniso8601
    contrib/python/blinker
    contrib/python/Flask
    contrib/python/flask-cors
    contrib/python/ipython
    contrib/python/PyYAML
    contrib/python/pathlib2
    contrib/python/requests
    contrib/python/setproctitle
    contrib/python/six
    contrib/python/uwsgi
    contrib/python/Werkzeug

    library/python/svn_version
    noc/hbf-server/hbf

    sandbox/common/abc
    sandbox/common/auth
    sandbox/common/config
    sandbox/common/format
    sandbox/common/fs
    sandbox/common/itertools
    sandbox/common/log
    sandbox/common/mds
    sandbox/common/patterns
    sandbox/common/proxy
    sandbox/common/rest
    sandbox/common/statistics
    sandbox/common/types
    sandbox/common/upload

    sandbox/etc

    sandbox/proxy/flask_uwsgi_websocket
    sandbox/proxy/websocket

    sandbox/proxy/common
    sandbox/proxy/plugins
)

RESOURCE(
    etc/.settings.yaml sandbox/proxy/etc/.settings.yaml
    etc/uwsgi.yaml sandbox/proxy/etc/uwsgi.yaml
)

PY_SRCS(
    __init__.py
    __main__.py
    app.py
    banned_networks.py
    config.py
    context.py
    daemon.py
    mds_download.py
    response_types.py
    wsgi.py

    mules/__init__.py
    mules/clients.py
)

END()

RECURSE(
    common
    etc
    flask_uwsgi_websocket
    plugins
    websocket
)

RECURSE_FOR_TESTS(
    tests
)
