"""
    !!! THIS MODULE IS DEPRECATED, USE SDK2 !!!
    For SDK2 tasks use `sandbox.sdk2.Task.current` instead of `channel` object
"""

from __future__ import absolute_import, unicode_literals

import logging
import threading

from sandbox.common import config as common_config

from sandbox.sdk2 import legacy

logger = logging.getLogger(__name__)


class SandboxChannel(object):
    """
    Class represents interface to communicate with tasks and resources
    """

    def __init__(self, sandboxapi_instance=None):
        self.__sandbox = threading.local()
        self.__sandbox.instance = sandboxapi_instance
        self.__sandbox.task = None

    @property
    def sandbox(self):
        instance = getattr(self.__sandbox, "instance", None)
        if instance is None:
            from sandbox.sandboxsdk import sandboxapi
            instance = self.__sandbox.instance = sandboxapi.Sandbox(common_config.Registry().client.xmlrpc_url)
        return instance

    @property
    def rest(self):
        instance = getattr(self.__sandbox, "rest", None)
        if instance is None:
            from sandbox.sandboxsdk import sandboxapi
            instance = self.__sandbox.rest = sandboxapi.SandboxRest()
        return instance

    @property
    def task(self):
        return legacy.current_task

    @task.setter
    def task(self, task):
        legacy.current_task = task


channel = SandboxChannel()
