# -*- coding: utf-8 -*-
"""
    !!! THIS MODULE IS DEPRECATED, USE `sandbox.common.errors` !!!
"""

from __future__ import absolute_import, unicode_literals

from sandbox.common import errors as common_errors

from sandbox.sdk2.vcs import svn
from sandbox.sdk2.helpers import gdb


class SandboxTaskUnknownError(common_errors.TaskError):
    pass


class SandboxTaskFailureError(common_errors.TaskFailure):
    pass


class SubprocessErrorBase(common_errors.SandboxException):
    task_context_field = '__subprocess_error'

    def __init__(
        self, message='', cmd_string=None, returncode=None, logs_resource=None,
        stdout_path=None, stderr_path=None, stdout_full_path=None, stderr_full_path=None
    ):
        super(SubprocessErrorBase, self).__init__(message)
        self.returncode = returncode
        self.cmd_string = cmd_string
        self.logs_resource = logs_resource
        self.stdout_path = stdout_path
        self.stderr_path = stderr_path
        self.stdout_full_path = stdout_full_path
        self.stderr_full_path = stderr_full_path

    def __write_error_info(self):
        """
            Возвращает описание ошибки в виде html
        """
        info = str(self)

        if self.stderr_path:
            stderr_info = gdb.get_html_view_for_logs_file("stderr", self.stderr_path, self.logs_resource)
            if stderr_info:
                info += '<br/>{0}'.format(stderr_info)

        if self.stdout_path:
            stdout_info = gdb.get_html_view_for_logs_file("stdout", self.stdout_path, self.logs_resource)
            if stdout_info:
                info += '<br/>{0}'.format(stdout_info)
            info += '<hr>'

        return info

    def get_task_info(self):
        """
            Вернуть описание для добавление в info-поле задачи
        """
        return self.__write_error_info()

    def get_task_context_value(self):
        """
            Вернуть значения для добавления информации об исключении в контекст задачи
        """
        return {
            'error': str(self),
            'cmd': self.cmd_string,
            'resource_id': self.logs_resource,
            'stderr': self.stderr_path,
            'stdout': self.stdout_path,
            'returncode': self.returncode
        }


class SandboxSubprocessError(SubprocessErrorBase, common_errors.TaskFailure):
    """ Error working with subprocess """


class SandboxSubprocessTimeoutError(SandboxSubprocessError):
    """ Процесс не уложился в отведённый таймаут """


class SandboxEnvironmentError(common_errors.SandboxEnvironmentError):
    """ Error while preparing environment """


SandboxSvnError = svn.SvnError
SandboxSvnPermanentError = svn.SvnPermanentError
SandboxSvnTemporaryError = svn.SvnTemporaryError
SandboxSvnIncorrectUrl = svn.SvnIncorrectUrl
SandboxSvnUserRequired = svn.SvnUserRequired
SandboxSvnPathNotExists = svn.SvnPathNotExists
SandboxSvnInvalidParameters = svn.SvnInvalidParameters
SandboxSvnTimeout = svn.SvnTimeout
