# -*- coding: utf-8 -*-
"""
    !!! THIS MODULE IS DEPRECATED, USE SDK2 !!!
    For SDK2 use parameters from `sandbox.sdk2.parameters`
"""

from __future__ import absolute_import, unicode_literals

import abc

from sandbox.common import itertools as common_itertools
from sandbox.common.types import task as ctt

from sandbox.sdk2.legacy import (
    SandboxParameter, SandboxStringParameter, SandboxInfoParameter,
    SandboxIntegerParameter, SandboxFloatParameter, SandboxBoolParameter, SandboxBoolGroupParameter,
    SandboxUrlParameter, SandboxSvnUrlParameter, SandboxArcadiaUrlParameter,
    SandboxRadioParameter, TaskSelector, ResourceSelector, LastReleasedResource, Container
)

__all__ = (
    "SandboxParameter", "SandboxStringParameter", "SandboxInfoParameter",
    "SandboxIntegerParameter", "SandboxFloatParameter", "SandboxBoolParameter", "SandboxBoolGroupParameter",
    "SandboxUrlParameter", "SandboxSvnUrlParameter", "SandboxArcadiaUrlParameter",
    "SandboxRadioParameter", "TaskSelector", "ResourceSelector", "LastReleasedResource", "Container",
    "SandboxGitUrlParameter", "SandboxSelectParameter", "ListRepeater", "DictRepeater"
)


class SandboxGitUrlParameter(SandboxParameter):

    name = "git_url"
    description = "Git url:"
    ui = SandboxParameter.UI(ctt.ParameterType.STRING)
    required = True


class SandboxSelectParameter(SandboxStringParameter):
    """
        Selector field - just an alias to :class:`SandboxStringParameter`
    """


class RepeaterMeta(abc.ABCMeta):
    """ Service meta class to control possible instantiation variants. """
    def __init__(cls, what, bases=None, dict=None):
        for i, base in enumerate(bases):
            if not i and base is object and len(bases) == 1:
                break
            if not i and getattr(base, "__metaclass__", None) is not RepeaterMeta:
                raise TypeError("Unsupportable base type {!r}".format(base))
            elif i and base is not SandboxStringParameter:
                raise TypeError("Unsupportable parameter type {!r}".format(base))
        super(RepeaterMeta, cls).__init__(what, bases, dict)
        if len(bases) > 1:
            cls.ui = bases[1].ui.__class__(*[v for _, v in bases[1].ui])  # "copy" method does not work properly
            cls.ui.modifiers = cls.ui.modifiers or {}
            cls.ui.modifiers["repetition"] = bases[0].__repetition__


class ListRepeater(object):
    """ Mixin. Specifies the parameter can be repeated as list on task creation. """
    __metaclass__ = RepeaterMeta
    __repetition__ = "list"

    @classmethod
    def cast(cls, value):
        if not value:
            return None
        return list(map(super(ListRepeater, cls).cast, common_itertools.chain(value)))


class DictRepeater(object):
    """ Mixin. Specifies the parameter can be repeated as dict (string key + value) on task creation. """
    __metaclass__ = RepeaterMeta
    __repetition__ = "dict"

    @classmethod
    def cast(cls, value):
        if not value:
            return None
        if not hasattr(value, "__iter__"):
            raise TypeError("Value {!r} should be a dictionary or a list of key-value pairs".format(value))
        ret = {}
        items = (
            value.iteritems()
            if isinstance(value, dict) else
            (value if isinstance(value[0], (list, tuple)) else [value])
        )
        for k, v in items:
            k = SandboxStringParameter.cast(k)
            if not k:
                raise ValueError("Key cannot be empty.")
            ret[k] = super(DictRepeater, cls).cast(v)
        return ret
