# -*- coding: utf-8 -*-

from __future__ import absolute_import, unicode_literals

import logging

logger = logging.getLogger(__name__)

from sandbox.common import config as common_config
from sandbox.common import system as common_system

from sandbox.sdk2.helpers import gdb

from sandbox.sandboxsdk import channel

__all__ = ("system_info", "is_arch_compatible", "filter_traceback")


def system_info():
    """ Temporary function till tasks' code update. """
    return common_system.get_sysparams()


def is_arch_compatible(arch1, arch2=None):
    """
        | check for arch1 to compatible with arch2
        | **any** arch compatible with all

        :param arch1: arch to compare with
        :param arch2: arch to compare with. if None - compare with current

        :return: True if compatible or False
    """
    if arch2 is None:
        arch2 = common_config.Registry().this.system.family
    if arch1 == "any" or arch2 == "any":
        return True
    return arch1 == arch2


def filter_traceback(traceback_path, output_html):
    """
        Filter gdb traceback to html file

        :return created filtered traceback resource id
        :rtype int
    """
    task = channel.channel.task
    filter_dir = task.abs_path("coredump_filter")
    gdb.filter_traceback(task.id, filter_dir, traceback_path, output_html)
