from __future__ import unicode_literals, print_function

import sys

from library.python import oauth

try:
    from library.python.runtime_py3 import entry_points
except ImportError:
    from library.python.runtime import entry_points

from sandbox.common import auth, console, rest

api = None


def main(repl=True):
    global api

    cz = console.AnsiColorizer()
    try:
        token = oauth.get_token(
            client_id="01dbc920803c486aafc5b6b06a3e34e4",
            client_secret="33ebfcd2078d4c05beb977aef15fe252",
            raise_errors=True
        )
    except oauth.Error as error:
        print(cz.red("Error: Failed to get ya token: {}".format(error)))
        print(cz.yellow("Warning: 'api' is not initialized"))
    else:
        rest.Client._external_auth = auth.OAuth(token)
        api = rest.Client()
        print("Authenticated as {}".format(api.user.current[:]["login"]))

    if repl:
        entry_points.repl()


if "yapy" in sys.argv[0]:
    main(repl=False)
