# coding: utf-8
from __future__ import unicode_literals

import collections

from six.moves import urllib_parse as urlparse

from sandbox.common import rest
from sandbox.common import patterns

Resource = collections.namedtuple("Resource", ("id", "size", "sources", "proxy"))
Client = collections.namedtuple("Client", ("fqdn", "dc", "storage"))


@patterns.singleton
def _api():
    kwargs = {}
    if not rest.Client._external_auth:  # outside a Sandbox task
        from library.python import oauth
        token = oauth.get_token(
            client_id="01dbc920803c486aafc5b6b06a3e34e4",
            client_secret="33ebfcd2078d4c05beb977aef15fe252"
        )
        kwargs["auth"] = token
    return rest.Client(version=2, **kwargs) << rest.Client.HEADERS({"X-Links": "1"})


@patterns.singleton
def _fqdn_to_client():
    result = {}
    api = _api()
    resp = api.client.read(limit=5000)
    for item in resp["items"]:
        try:
            fqdn, dc = item["fqdn"], item["dc"]
            result[fqdn] = Client(fqdn, dc, "STORAGE" in item["tags"])
        except KeyError:
            pass
    return result


def resolve_resources(fetch_sources=True, **kwargs):
    api = _api()

    fqdn_to_client = {}
    if fetch_sources:
        fqdn_to_client = _fqdn_to_client()

    result = {}

    kwargs.update(limit=3000)
    resp = api.resource.read(**kwargs)

    for res in resp["items"]:
        if res["state"] != "READY":
            continue

        # Skip resources that do not need backup
        attrs = res.get("attributes", {})
        if "backup_task" not in attrs and not attrs.get("ttl") == "inf":
            continue

        sources = []

        if fetch_sources:
            for link in res["http"]["links"]:
                url = urlparse.urlparse(link)
                hostname = url.hostname
                client = fqdn_to_client.get(hostname)
                if not client:
                    continue
                sources.append(client)
            if not sources:
                continue

        result[res["id"]] = Resource(res["id"], res["size"], sources, res["http"]["proxy"])

    return result
