# coding: utf-8
from __future__ import unicode_literals

import re

import six

from sandbox.common import itertools as citertools

from . import utils

map = six.moves.map


def _task_ids(d):
    for key, value in six.iteritems(d):
        if key == "sandbox_id":
            for id_ in citertools.chain(value):
                yield id_
        if isinstance(value, dict):
            for id_ in _task_ids(value):
                yield id_


def _resource_ids(d):
    for key, value in six.iteritems(d):
        if isinstance(value, (six.binary_type, six.text_type)):
            for id_ in re.findall(r'sbr:(\d+)', value):
                yield int(id_)
        if isinstance(value, dict):
            for id_ in _resource_ids(value):
                yield id_


def resources(conf, fetch_sources=True):
    result = {}

    for rids in citertools.grouper(_resource_ids(conf), 30):
        result.update(utils.resolve_resources(id=",".join(map(str, rids)), fetch_sources=fetch_sources))

    for tids in citertools.grouper(_task_ids(conf), 30):
        result.update(utils.resolve_resources(task_id=",".join(map(str, tids)), fetch_sources=fetch_sources))

    return result
