#!/usr/bin/env python

import os
import sys
import argparse
import collections

mydir = os.path.dirname(os.path.abspath(__file__))
sys.path.append(os.path.dirname(mydir))

import yasandbox.database.upgrade
from sandbox.yasandbox import controller


def args_handler():
    parser = argparse.ArgumentParser(
        formatter_class=lambda *args, **kwargs: argparse.ArgumentDefaultsHelpFormatter(*args, width=120, **kwargs),
        description='Database upgrade tool.'
    )
    parser.add_argument(
        '--pre',
        default=False,
        action="store_true",
        help='Execute only pre-upgrade stage scripts.'
    )
    parser.add_argument(
        '--force',
        default=False,
        action="store_true",
        help='Execute all scripts even the database is marked as up-to-date.'
    )
    return parser.parse_args()


def main(pre_only=False, force=False):
    controller.Settings.initialize()
    none_applied = collections.namedtuple('Fake', ('pre', 'main', 'post'))(*([[]] * 3))
    with controller.Settings.upgrade_recorder() as recorder:
        applied = recorder.recorded if not force else none_applied
        updater = yasandbox.database.upgrade.apply_missing(applied, pre_only=pre_only)
        for args in updater:
            recorder.record(*args)

if __name__ == '__main__':
    args = args_handler()
    main(args.pre, args.force)
