import copy
import json
import itertools

from library.python import resource


def positions():
    for y in itertools.count(6, step=6):
        for x in (0, 12):
            yield {"h": 6, "w": 12, "x": x, "y": y}


def main():

    dashboard = json.loads(resource.find("dashboard.json"))
    panel_template = json.loads(resource.find("panel.json"))

    services = json.loads(resource.find("services.json"))
    services.sort(key=lambda x: ("." in x, x))  # move threaded services to the end

    panels = []
    poses = positions()

    for service, pos, id_ in zip(services, poses, itertools.count(2)):
        panel = copy.deepcopy(panel_template)
        panel["id"] = id_
        panel["title"] = service + " ticks"
        panel["gridPos"] = pos
        panel["targets"][0]["query"] = panel["targets"][0]["query"].replace("__service__", service)

        panels.append(panel)

    dashboard["panels"].extend(panels)

    print(json.dumps(dashboard, indent=2))


if __name__ == "__main__":
    main()
