#!/usr/bin/env bash

# put this script, say, after arcadia:/robots/trunk/genconf/PORTOVM/search/qemu_scripts.sh in BUILD_PORTO_LAYER task's parameters
# to tune the layer for local Sandbox's needs

# use dns64
tee /etc/resolv.conf /etc/resolv.conf.dns64 << EOF
search search.yandex.net yandex.ru
# about nameservers duplication: SANDBOX-3815
nameserver 2a02:6b8:0:3400::5005
nameserver 2a02:6b8:0:3400::5005
EOF

chmod a+rw /etc/resolv.conf /etc/resolv.conf.dns64

# install MongoDB
export DEBIAN_FRONTEND=noninteractive
apt-get -q update
apt-get -y install apt-transport-https
apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv 2930ADAE8CAF5059EE73BB4B58712A2291FA4AD5
echo "deb [ arch=amd64,arm64 ] https://repo.mongodb.org/apt/ubuntu xenial/mongodb-org/3.6 multiverse" | tee /etc/apt/sources.list.d/mongodb-org-3.6.list
apt-get -q update
apt-get -y install fuse
apt-get -y -q install --yes cgroup-lite lxc
apt-get -y -q install mongodb-org=3.6.4 mongodb-org-server=3.6.4 mongodb-org-shell=3.6.4 mongodb-org-mongos=3.6.4 mongodb-org-tools=3.6.4
systemctl enable mongod
sed -i -r 's,\[Service\],\[Service\]\nRestart=always,g' /lib/systemd/system/mongod.service

# self-explanatory (Porto conflicts with LXC)
apt purge --yes yandex-porto

# patch max no. of threads and open files
tee -a /etc/security/limits.conf << EOF
* - nproc 100000
* - nofile 100000
EOF

tee /etc/cauth/cauth.conf << "EOF"
# Generated by qemu-sandbox-step.sh for image customization
sources="cms,idm,yp"
EOF

# systemd<229-4ubuntu6 has a default limitation of 512 threads per process: https://github.com/systemd/systemd/issues/3211
apt-get -y install systemd

tee -a /etc/update-motd.d/95-sandbox << EOF
#!/bin/bash

echo -e "\033[0;33m"
echo '   _____                 _ _               '
echo '  / ____|               | | |              '
echo ' | (___   __ _ _ __   __| | |__   _____  __'
echo '  \___ \ / _\` | '"'"'_ \ / _\` | '"'"'_ \ / _ \ \/ /'
echo '  ____) | (_| | | | | (_| | |_) | (_) >  < '
echo ' |_____/ \__,_|_| |_|\__,_|_.__/ \___/_/\_\'
echo -e "\033[0m"
echo -e "\033[1;34m    https://sandbox.yandex-team.ru\033[0m"
echo -e "\033[1;34m    https://wiki.yandex-team.ru/Sandbox\033[0m"
EOF
chmod a+x /etc/update-motd.d/95-sandbox

# SANDBOX-5366: patch SkyNET root symlink for LXC to work (it must point to an absolute path)
SKYNET_ROOT="/Berkanavt"
SKYNET_REAL_ROOT="/place/berkanavt"
SKYNET_FAULTY_ROOT="place/berkanavt"

[[ "$(readlink ${SKYNET_ROOT})" = "${SKYNET_FAULTY_ROOT}" ]] && rm "${SKYNET_ROOT}" && ln -s "${SKYNET_REAL_ROOT}" "${SKYNET_ROOT}"

tee -a /etc/skel/.bashrc << "EOF"
# correct locale is required for Sandbox server application to work
export LANG=en_US.UTF-8 LC_CTYPE=en_US.UTF-8
EOF
