#!/home/zomb-sandbox/venv/bin/python

import re
import sys
import argparse
import collections

sys.path.extend(["/skynet", "server", "sdk", "tasks"])

import common.console
import common.types.task as ctt

import yasandbox.manager
import yasandbox.controller
import yasandbox.database.mapping


def handle_args():
    parser = argparse.ArgumentParser(
        formatter_class=lambda *args, **kwargs: argparse.ArgumentDefaultsHelpFormatter(*args, width=120, **kwargs),
        description="Sandbox resources backup tasks distributor tool."
    )
    parser.add_argument(
        "regex",
        metavar="REGEX",
        help="Regular expression to match BACKUP_RESOURCE tasks"
    )
    parser.add_argument(
        "hosts",
        metavar="HOST", nargs="+",
        help="Hosts for tasks distribution"
    )
    return parser.parse_args()


def main(args):
    with common.console.LongOperation("Querying the database..."):
        tasks = list(yasandbox.database.mapping.Task.objects(
            type="BACKUP_RESOURCE_2",
            execution__status=ctt.Status.ENQUEUED,
            description=re.compile(args.regex),
        ))

    cnt = collections.Counter()
    hosts = collections.deque(args.hosts)
    pb = common.console.ProgressBar("Updating tasks", len(tasks))
    cache = yasandbox.controller.TaskQueue.HostsCache()
    for t in tasks:
        h = hosts[0]
        hosts.rotate(-1)
        t = yasandbox.controller.TaskWrapper(t)
        t.model.requirements.host = h
        yasandbox.controller.TaskQueue.update_task_execution_hosts_list(t.model, cache)
        t.save()
        cnt[h] += 1
        pb.add(1)
    pb.finish()

    print("Total counters: {!r}".format(cnt))
    return 0


if __name__ == "__main__":
    with common.console.LongOperation("Initializing"):
        yasandbox.manager.use_locally()
        import common.projects_handler
        common.projects_handler.load_project_types()
        yasandbox.manager.use_locally()
    sys.exit(main(handle_args()))
