#!/usr/bin/env python

import sys
import os
import zlib
import base64
import marshal
import argparse
import pstats


class FakeStatSource(object):
    """
    take stats in constructor.
    provide .stats member with it
    have create_stats() to fool pstats.Stats.load_stats()
    """
    def __init__(self, stats):
        self.stats = stats

    def create_stats(self):
        pass


def add_stats(main_stat, another_stat):
    """
    add another_stat to main_stat
    return main_stat
    """
    if main_stat is None:
        return another_stat
    else:
        main_stat.add(another_stat)
        return main_stat


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('file_name', help='profiler file path')
    parser.add_argument(
        '-s', '--sort', dest='sort', default=None,
        help='Field to order by. Available choices: {}'.format(
            ', '.join((
                "{} ({})".format(key, value[1])
                for key, value in sorted(pstats.Stats.sort_arg_dict_default.iteritems())
            ))
        )
    )
    parser.add_argument(
        '-k', '--create_kcachegrind', dest='kcachegrind', action='store_true',
        help='Convert profile to a kcachegrind-readable format (available as {original path}.kgrind)'
    )
    args = parser.parse_args()

    main_stat = None

    if args.kcachegrind:
        kcachegrind_tmp_file = open(args.file_name + '.kgrind.tmp', 'wb')

    with open(args.file_name, 'rb') as f:
        for line in f:
            try:
                _, name, data = line.split()
                data = base64.decodestring(data)
                try:
                    data = zlib.decompress(data)
                except zlib.error:
                    pass
                if args.kcachegrind:
                    kcachegrind_tmp_file.write(data)
                else:
                    data = marshal.loads(data)
                    stat_source = FakeStatSource(data)
                    stat_piece = pstats.Stats(stat_source)
                    main_stat = add_stats(main_stat, stat_piece)
            except:
                continue

    if args.kcachegrind:
        kcachegrind_tmp_file.close()
        from pyprof2calltree import convert
        convert(args.file_name + '.kgrind.tmp', args.file_name + '.kgrind')
        os.unlink(args.file_name + '.kgrind.tmp')
        print args.file_name + '.kgrind'
        sys.exit(0)

    if main_stat:
        if args.sort:
            main_stat.sort_stats(args.sort)
        main_stat.print_stats()
    else:
        print >>sys.stderr, 'no profile data found'
