#!/usr/bin/env python
# coding: utf-8

'''
Статичтика по загружености хоста.
'''

import datetime

LOGFILE = '/place/var/log/sandbox/executor.log'

BEGIN_TASK = 'handle command execute'
END_TASK = 'handle command finish'


def main():
    for i in range(1, 31):
        yesterday = (datetime.datetime.now() - datetime.timedelta(days=i)).strftime("%Y-%m-%d")
        print "--- Статиcтика за %s ---" % yesterday
        start = []
        end = []
        with open(LOGFILE) as f:
            for l in f:
                if not l.startswith(yesterday):
                    continue
                # omit first finish
                if END_TASK in l and not start:
                    continue
                # omit more than one occurence of finish command
                if END_TASK in l and len(start) == len(end):
                    continue
                # omit more than one occurence of start command
                if BEGIN_TASK in l and len(start) > len(end):
                    continue
                if BEGIN_TASK in l or END_TASK in l:
                    if BEGIN_TASK in l:
                        array = start
                    else:
                        array = end
                    d, t = l.split()[:2]
                    array.append(datetime.datetime.strptime('%s %s' % (d, t), '%Y-%m-%d %H:%M:%S,%f'))
            durations = []
            for a, b in zip(start, end):
                durations.append(b - a)
            if not durations:
                print "    Задачи не выполнялись"
                continue
            durations.sort()
            print "    Кол-во выполненных задач: %s" % len(durations)
            print "    Самая быстрая задача: %s" % durations[0]
            print "    Самая мелденная задача: %s" % durations[-1]
            print "    Медиана: %s" % durations[len(durations) / 2]
            print "    Приблизительная загрузка машины: %.2f%%" % ((sum(
                (td.microseconds + (td.seconds + td.days * 24 * 3600) * 10 ** 6) / 10 ** 6
                for td in durations) / 86400.0) * 100
            )


if __name__ == "__main__":
    main()
