#!/home/zomb-sandbox/venv/bin/python

from __future__ import print_function

import sys
import argparse
import subprocess as sp


sys.path = filter(
    lambda p: any(map(p.startswith, ("/skynet", "/home/zomb-sandbox"))),
    sys.path
)


def mass_revision_removal():
    print("Removing .revision files on servers to force them to update tasks code")
    sp.check_call([
        "sky", "run",
        "sudo rm -v /samogon/*/active/user/server_launcher/srvdata/packages/tasks/.revision",
        "k@sandbox_server"
    ])


def rollback_tasks_code(revision, types, limit):
    """
    :param revision: revision to roll back to (INCLUSIVE)
    :param types: resource types to check
    :param limit: how many objects to load from the database during rollback
    """

    from sandbox.yasandbox import manager
    from sandbox.yasandbox.database import mapping
    import sandbox.yasandbox.services.update_sandbox_resources as usr

    mapping.ensure_connection()
    manager.use_locally()

    for r in mapping.Resource.objects(type__in=types, owner="SANDBOX").order_by("-id").limit(limit):
        attrs = {_.key: _.value for _ in r.attributes}
        if int(attrs.get("commit_revision", 0)) >= revision and attrs.get("auto_deploy"):
            r.attributes = [_ for _ in r.attributes if _.key != "auto_deploy"]
            r.save()
            print("{} updated".format(r.id))

    usr.UpdateSandboxResources(stopping=None, logger=None, rwlock=None)._proc()
    mass_revision_removal()


def main():
    parser = argparse.ArgumentParser(
        description=(
            "Remove \"auto_deploy=True\" from tasks archives down to specified revision "
            "(including the revision itself) and remove .revision file to make the update possible. "
            "This guarantees that all servers will attempt to start on previous tasks code "
            "within web server restart interval (30s) or so."
        )
    )

    parser.add_argument(
        "-r", "--revision", type=int, required=True, help="Revision to discard tasks code down to, inclusive"
    )
    parser.add_argument(
        "-t", "--types",
        type=lambda s: [_ for _ in s.split() if _],
        default=["SANDBOX_TASKS_ARCHIVE", "SANDBOX_TASKS_IMAGE"],
        help="Resource types to check"
    )
    parser.add_argument(
        "-l", "--limit", type=int, default=100,
        help="How many objects to load from the database during rollback"
    )

    args = parser.parse_args()
    return rollback_tasks_code(args.revision, args.types, args.limit)


if __name__ == "__main__":
    main()
