#!/usr/bin/env python

import argparse

from sandbox import common
from sandbox.serviceq import types as qtypes
from sandbox.yasandbox import controller


def main():
    parser = argparse.ArgumentParser(
        formatter_class=argparse.ArgumentDefaultsHelpFormatter,
        description="Script for getting state snapshot from Service Q primary server."
    )
    parser.add_argument(
        "-o", "--output-filename", dest="output_filename", required=True, type=str, help="Output file name",
    )
    args = parser.parse_args()

    qclient = controller.TaskQueue.qclient
    assert qclient.status(secondary=False) == qtypes.Status.PRIMARY

    snapshot = qclient.snapshot()
    snapshot_id, snapshot_size = snapshot.next()

    chunks = []
    size = 0
    progress_bar = common.console.ProgressBar(
        "Receiving snapshot #{} ({})".format(snapshot_id, common.utils.size2str(snapshot_size)),
        snapshot_size
    )
    for chunk in snapshot:
        chunks.append(chunk)
        size += len(chunk)
        progress_bar.add(size)
    progress_bar.finish()
    assert size == snapshot_size, "Received {} instead of {} bytes".format(size, snapshot_size)
    data = "".join(chunks)
    with open(args.output_filename, "wb") as f:
        f.write(data)

if __name__ == "__main__":
    main()
