# coding: utf-8
from __future__ import division, print_function, unicode_literals

from six.moves import urllib

from .. import consts, common_args, utils


def run_acceptance(task_args):

    base_url = consts.SANDBOX_BASE_URLS["testing"]

    parsed_base_url = urllib.parse.urlparse(base_url)
    client = utils.sandbox_client(base_url)

    data = dict(
        type="SANDBOX_ACCEPTANCE",
        owner=task_args.owner,
        kill_timeout=10 * 60,
        priority={"class": "SERVICE", "subclass": "HIGH"},
        description="Sandbox acceptance",
    )
    task_id = client.task(**data)["id"]

    task_url = parsed_base_url._replace(path="/task/{}".format(task_id))
    task_url = urllib.parse.urlunparse(task_url)

    if task_args.draft:
        print(task_url)
        return

    resp = client.batch.tasks.start.update(id=[task_id])

    for result in resp:
        status = result["status"]
        print("%s: %s" % (status, task_url))
        if status != "SUCCESS":
            print("    {}".format(result["message"]))


def main(args):
    task_args = common_args.Task.create(args)
    run_acceptance(task_args=task_args)


def setup_parser(parser):
    common_args.Task.setup(parser)
    parser.set_defaults(func=main)
