# coding: utf-8
from __future__ import division, print_function, unicode_literals

import argparse

from .commands import acceptance, build, dead, mds, revive, yp_allocate, abcd, dispenser, monitoring, task_restart


def main():
    parser = argparse.ArgumentParser(prog="excavator")
    subparsers = parser.add_subparsers()

    dead_parser = subparsers.add_parser("dead", help="Dead clients")
    dead.setup_parser(dead_parser)

    mds_parser = subparsers.add_parser("mds", help="MDS operations")
    mds.setup_parser(mds_parser)

    build_parser = subparsers.add_parser("build", help="Build releases")
    build.setup_parser(build_parser)

    acceptance_parser = subparsers.add_parser("acceptance", help="Run SANDBOX_ACCEPTANCE on testing")
    acceptance.setup_parser(acceptance_parser)

    revive_parser = subparsers.add_parser("revive", help="Poke dead clients with a stick")
    revive.setup_parser(revive_parser)

    yp_allocate_parser = subparsers.add_parser("yp_allocate", help="Create nanny pod sets in sandbox yp-segment")
    yp_allocate.setup_parser(yp_allocate_parser)

    abcd_parser = subparsers.add_parser("abcd", help="ABCD operations")
    abcd.setup_parser(abcd_parser)

    monitoring_parser = subparsers.add_parser("monitoring", help="Conductor, Walle, Sandbox, Samogon monitoring tool")
    monitoring.setup_parser(monitoring_parser)

    dispenser_parser = subparsers.add_parser("dispenser", help="Dispenser operations")
    dispenser.setup_parser(dispenser_parser)

    task_restart_parser = subparsers.add_parser("task_restart", help="Task restart")
    task_restart.setup_parser(task_restart_parser)

    parser.set_defaults(func=lambda _: parser.error("too few arguments"))
    args = parser.parse_args()
    args.func(args)
