PY3_PROGRAM(excavator)

OWNER(g:sandbox-dev)

PEERDIR(
    skynet/library
    library/python/oauth
    library/python/par_apply
    library/python/vault_client

    contrib/python/boto3
    contrib/python/dateutil
    contrib/python/ipython
    contrib/python/paramiko
    contrib/python/six
    contrib/python/terminaltables

    sandbox/common/abc
    sandbox/common/auth
    sandbox/common/config
    sandbox/common/console
    sandbox/common/enum
    sandbox/common/format
    sandbox/common/mds
    sandbox/common/rest
    sandbox/common/tvm
    sandbox/common/types
    sandbox/common/patterns
    sandbox/etc

    yp/python/yp/client
    yt/python/yt/yson

    infra/nanny/yp_lite_api/py_stubs
    infra/nanny/nanny_rpc_client
)

PY_SRCS(
    common_args.py
    main.py
    consts.py
    utils.py
    host_classes.py

    commands/__init__.py
    commands/abcd.py
    commands/acceptance.py
    commands/build.py
    commands/common.py
    commands/dead.py
    commands/dispenser.py
    commands/mds.py
    commands/monitoring.py
    commands/revive.py
    commands/yp_allocate.py
    commands/task_restart.py
)

PY_MAIN(sandbox.scripts.tools.excavator.main)

END()
