import os
import shutil
import subprocess as sp

import utils

from sandbox import sdk2


YANDEX_INTERNAL_CERT = """
Yandex Internal
===============
-----BEGIN CERTIFICATE-----
MIIFGTCCAwGgAwIBAgIQJMM7ZIy2SYxCBgK7WcFwnjANBgkqhkiG9w0BAQ0FADAf
MR0wGwYDVQQDExRZYW5kZXhJbnRlcm5hbFJvb3RDQTAeFw0xMzAyMTExMzQxNDNa
Fw0zMzAyMTExMzUxNDJaMB8xHTAbBgNVBAMTFFlhbmRleEludGVybmFsUm9vdENB
MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAgb4xoQjBQ7oEFk8EHVGy
1pDEmPWw0Wgw5nX9RM7LL2xQWyUuEq+Lf9Dgh+O725aZ9+SO2oEs47DHHt81/fne
5N6xOftRrCpy8hGtUR/A3bvjnQgjs+zdXvcO9cTuuzzPTFSts/iZATZsAruiepMx
SGj9S1fGwvYws/yiXWNoNBz4Tu1Tlp0g+5fp/ADjnxc6DqNk6w01mJRDbx+6rlBO
aIH2tQmJXDVoFdrhmBK9qOfjxWlIYGy83TnrvdXwi5mKTMtpEREMgyNLX75UjpvO
NkZgBvEXPQq+g91wBGsWIE2sYlguXiBniQgAJOyRuSdTxcJoG8tZkLDPRi5RouWY
gxXr13edn1TRDGco2hkdtSUBlajBMSvAq+H0hkslzWD/R+BXkn9dh0/DFnxVt4XU
5JbFyd/sKV/rF4Vygfw9ssh1ZIWdqkfZ2QXOZ2gH4AEeoN/9vEfUPwqPVzL0XEZK
r4s2WjU9mE5tHrVsQOZ80wnvYHYi2JHbl0hr5ghs4RIyJwx6LEEnj2tzMFec4f7o
dQeSsZpgRJmpvpAfRTxhIRjZBrKxnMytedAkUPguBQwjVCn7+EaKiJfpu42JG8Mm
+/dHi+Q9Tc+0tX5pKOIpQMlMxMHw8MfPmUjC3AAd9lsmCtuybYoeN2IRdbzzchJ8
l1ZuoI3gH7pcIeElfVSqSBkCAwEAAaNRME8wCwYDVR0PBAQDAgGGMA8GA1UdEwEB
/wQFMAMBAf8wHQYDVR0OBBYEFKu5xf+h7+ZTHTM5IoTRdtQ3Ti1qMBAGCSsGAQQB
gjcVAQQDAgEAMA0GCSqGSIb3DQEBDQUAA4ICAQAVpyJ1qLjqRLC34F1UXkC3vxpO
nV6WgzpzA+DUNog4Y6RhTnh0Bsir+I+FTl0zFCm7JpT/3NP9VjfEitMkHehmHhQK
c7cIBZSF62K477OTvLz+9ku2O/bGTtYv9fAvR4BmzFfyPDoAKOjJSghD1p/7El+1
eSjvcUBzLnBUtxO/iYXRNo7B3+1qo4F5Hz7rPRLI0UWW/0UAfVCO2fFtyF6C1iEY
/q0Ldbf3YIaMkf2WgGhnX9yH/8OiIij2r0LVNHS811apyycjep8y/NkG4q1Z9jEi
VEX3P6NEL8dWtXQlvlNGMcfDT3lmB+tS32CPEUwce/Ble646rukbERRwFfxXojpf
C6ium+LtJc7qnK6ygnYF4D6mz4H+3WaxJd1S1hGQxOb/3WVw63tZFnN62F6/nc5g
6T44Yb7ND6y3nVcygLpbQsws6HsjX65CoSjrrPn0YhKxNBscF7M7tLTW/5LK9uhk
yjRCkJ0YagpeLxfV1l1ZJZaTPZvY9+ylHnWHhzlq0FzcrooSSsp4i44DB2K7O2ID
87leymZkKUY6PMDa4GkDJx0dG4UXDhRETMf+NkYgtLJ+UIzMNskwVDcxO4kVL+Hi
Pj78bnC5yCw8P5YylR45LdxLzLO68unoXOyFz1etGXzszw8lJI9LNubYxk77mK8H
LpuQKbSbIERsmR+QqQ==
-----END CERTIFICATE-----
"""


def reinstall_uwsgi(venv, env, requirements, log_directory):
    uwsgi_reqs = filter(lambda s: s.split("==")[0] == "uWSGI", requirements)
    uwsgi = next(iter(uwsgi_reqs), None)
    if uwsgi is None:
        raise RuntimeError("uWSGI isn't listed in requirements.txt")

    utils.install_requirements(
        venv, env, [uwsgi], log_directory, use_cflags_ldflags=True,
        pip_flags=("--ignore-installed", "--no-cache-dir")
    )


def wipe_bson_folder(venv, log_directory):
    def pymongo_has_c():
        with sdk2.helpers.ProcessLog(logger=str(log_directory / "pymongo_has_c")) as pl:
            pl.logger.propagate = 1
            return sp.Popen(
                [
                    os.path.join(venv.root_dir, "bin", "python"),
                    "-c",
                    "import sys, pymongo;sys.exit(int(not pymongo.has_c()))"
                ],
                stdout=pl.stdout, stderr=sp.STDOUT
            ).wait() == 0

    # bson folder can make pymongo's C extensions unusable
    junk_bson = os.path.join(venv.root_dir, "lib", "python2.7", "site-packages", "bson")
    if os.path.exists(junk_bson) and not pymongo_has_c():
        shutil.rmtree(junk_bson)

    if not pymongo_has_c():
        raise RuntimeError("Can not load pymongo's C extension")


def patch_certifi(venv):
    certifi_path = os.path.join(venv.root_dir, "lib", "python2.7", "site-packages", "certifi")
    if os.path.exists(certifi_path):
        with open(os.path.join(certifi_path, "cacert.pem"), "a") as f:
            f.write("\n")
            f.write(YANDEX_INTERNAL_CERT)
            f.write("\n")
