#!/skynet/python/bin/python
# -*- coding: utf-8 -*-

import sys
import xmlrpclib
import json


# pretty print json
def pj(js):
    return json.dumps(js, sort_keys=True, indent=4, separators=(',', ': '))


server = xmlrpclib.ServerProxy('https://sandbox.yandex-team.ru/sandbox/xmlrpc', allow_none=True)

if len(sys.argv) < 3:
    print "Usage: resource-by-task.py <task-id> <resource-type>"
    sys.exit(1)

resource_type = sys.argv[2]

resources = server.list_resources({'task_id': sys.argv[1], 'omit_failed': False})
for r in resources:
    if r['type_name'] != resource_type:
        continue

    # testws is currently on FreeBSD
    if r['arch'] != 'any' and r['arch'] != 'freebsd':
        continue

    print r['skynet_id']
