from __future__ import absolute_import

import json
import logging

from .process import subprocess as sp


__all__ = ("binary_resource", "binary_resource_attrs")


def binary_resource_attrs(binary_path, logger=logging):  # type: (str, logging.Logger) -> dict
    p = sp.Popen(
        [str(binary_path), "content", "--self-info"],
        stdout=sp.PIPE,
        stderr=sp.PIPE,
        env={"Y_PYTHON_ENTRY_POINT": "sandbox.taskbox.binary:main"},
    )
    out, err = p.communicate()
    logger.debug("Binary '%s' exited with code %s. STDOUT:\n%s", binary_path, p.returncode, out)
    if p.returncode != 0 or err:
        logger.warning("STDERR\n:%s", err)
    return json.loads(out)["resource_attributes"]


def binary_resource(description, binary_path, arch=None, attrs=None):

    from sandbox import sdk2

    resource_attributes = binary_resource_attrs(binary_path)
    if attrs is None:
        attrs = {}
    for attr_name, attr_value in resource_attributes.items():
        if attr_name not in attrs:
            attrs[attr_name] = attr_value

    return sdk2.service_resources.SandboxTasksBinary(sdk2.Task.current, description, binary_path, arch, **attrs)
