from __future__ import absolute_import

import sandbox.common.types.resource as ctr

from . import resource


class UnknownResource(resource.AbstractResource):
    """
    Special dummy resource type, which will be provided for all resource object, with type,
    which cannot be found by name inside tasks code.
    """


class TaskLogs(resource.ServiceResource):
    """ Task logs """
    name = ctr.TASK_LOG_RESOURCE_TYPE
    calc_md5 = False
    restart_policy = ctr.RestartPolicy.IGNORE
    share = False


class TaskCustomLogs(TaskLogs):
    """ Custom task logs """


class LxcContainer(resource.AbstractResource):
    """ Tarball with LXC image """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True


class BasePortoLayer(resource.AbstractResource):
    releasable = True
    auto_backup = True


class CoreDump(resource.ServiceResource):
    """ Core dump of failed process. """
    any_arch = False
    restart_policy = ctr.RestartPolicy.IGNORE


class FilteredGdbTraceback(resource.AbstractResource):
    """ Filtered traceback (responsible person: mvel@) """
    auto_backup = True
    share = False
    restart_policy = ctr.RestartPolicy.DELETE


class SandboxTasksArchive(resource.AbstractResource):
    """ Archive with sandbox tasks code """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True
    restart_policy = ctr.RestartPolicy.IGNORE


class SandboxTasksBinary(resource.AbstractResource):
    """ Sandbox tasks' binary """
    releasable = True
    auto_backup = True
    executable = True
    any_arch = False


class SandboxTasksImage(SandboxTasksArchive):
    """ SquashFS image with Sandbox tasks code """


class TestTaskResource(resource.Resource):
    """ Resource for test tasks and tests """
    restart_policy = ctr.RestartPolicy.DELETE
    releasers = ["guest", "test-api-user", "robot-geosearch", "robot-garden-sandbox"]
    release_subscribers = ["sdfsdf", "ggggggggg", "testtesttesttest"]
    releasable = True
    share = False


class TestTaskResource2(resource.Resource):
    """ Resource for sandbox unit-tests """


class ArcadiaApiClient(resource.Resource):
    """ Arcadia API client """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = ["akastornov"]


class ArcClient(resource.Resource):
    """ Arc VCS client """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = [
        "ilikepugs",
        "gotocoding",
        "kikht",
        "nslus",
        "otarakan",
        "robot-srch-releaser",
        "robot-testenv",
        "tldr",
    ]
    ttl = "inf"
    sync_upload_to_mds = True
