from __future__ import absolute_import

import time
import threading
import contextlib

from . import legacy


# This code below is used only in some autocheck tasks. It should be moved to sandbox.projects.common package.
TASK_STAT = "__TASK_STAT"
LOCK = threading.Lock()


def make_default_stat():
    return {"time": 0, "qty": 0}


def _update_ctx(action):
    if legacy.current_task:
        ctx = legacy.current_task.ctx
        with LOCK:
            if TASK_STAT not in ctx:
                ctx[TASK_STAT] = {}
            action(ctx[TASK_STAT])  # avoid recursive locking from here


def update_stat_field(field_name, action, default_value=None):
    def updater(dct):
        if field_name not in dct:
            dct[field_name] = default_value

        action(dct[field_name])

    _update_ctx(updater)


def make_updater(delta):
    def stat_updater(dct):
        dct["time"] += delta
        dct["qty"] += 1

    return stat_updater


@contextlib.contextmanager
def measure_time(field_name):
    st = time.time()
    try:
        yield
    finally:
        end = time.time()
        update_stat_field(field_name, make_updater(end - st), make_default_stat())
