from sandbox import common


class Path(object):
    """ Path constants """
    NOT_IMPLEMENTED_URL = "/api/<version>/<path:path>"  # rule for unknown api urls
    PATH_INFO = "PATH_INFO"  # path in request environ
    MAX_VERSION = 25  # TODO: max version for api


class UWSGIKey(common.utils.Enum):
    """ Keys for uwsgi level """

    REQUESTS_IN_PROGRESS = 0
    API_QUOTAS = 1


class LegacyAPI(object):
    schema = "http"
    host = "localhost"

    @common.utils.singleton_classproperty
    def port(cls):
        return common.config.Registry().server.web.address.port

    @common.utils.singleton_classproperty
    def url(cls):
        return "{}://{}:{}/".format(cls.schema, cls.host, cls.port)


class Suggest(object):
    """ Suggest constants """

    UWSGI_CACHE_NAME = "suggest"
    UWSGI_CACHE_TTL = 1200  # seconds
    CACHE_SLEEP_INTERVAL = 200  # seconds


class ApiConsumption(object):
    """ Api consumption constants """

    UWSGI_CACHE_NAME = "api_consumption"
    UWSGI_CACHE_TTL = 60  # seconds
    CONSUMPTION_KEY_NAME = "api_consumption"
