import six
import flask

from sandbox.serviceapi.web import routes

__all__ = ("init_handlers",)


def http_error_handler(ex):
    body = {"message": ex.message}
    return flask.jsonify(body), ex.code


def base_error_handler(ex):
    body = {"message": str(ex)}
    return flask.jsonify(body), six.moves.http_client.INTERNAL_SERVER_ERROR


def init_handlers(app):
    bp = routes.get_blueprint_by_version(
        1, "quotaManagement",
        custom_http_error_handler=http_error_handler, custom_base_error_handler=base_error_handler
    )
    app.register_blueprint(bp)

    # import all handlers here to register them.
    from . import accounts as accounts_api  # noqa
