from __future__ import absolute_import

from sandbox.common import api
from sandbox.common.types import user as ctu

from .api import Api
from . import schemas


class GetAccount(Api.Path("/providers/{providerId}/accounts/{accountId}/_getOne")):
    class Post(api.Post):
        __security__ = ctu.Restriction.TVM_SERVICE

        providerId = schemas.common.ProviderId(scope=api.Scope.PATH)
        accountId = schemas.common.AccountId(scope=api.Scope.PATH)

        data = schemas.account.GetAccountRequest("Get account request", required=True, scope=api.Scope.BODY)

        class Ok(api.Response):
            schema = schemas.account.Account()


class CreateAccount(Api.Path("/providers/{providerId}/accounts")):
    class Post(api.Post):
        __security__ = ctu.Restriction.TVM_SERVICE

        providerId = schemas.common.ProviderId(scope=api.Scope.PATH)

        data = schemas.account.CreateAccountAndProvideRequest(
            "Create account request", required=True, scope=api.Scope.BODY
        )

        class Ok(api.Response):
            schema = schemas.account.Account()


class DeleteAccount(Api.Path("/providers/{providerId}/accounts/{accountId}")):
    class Delete(api.Delete):
        __security__ = ctu.Restriction.TVM_SERVICE

        providerId = schemas.common.ProviderId(scope=api.Scope.PATH)
        accountId = schemas.common.AccountId(scope=api.Scope.PATH)

        data = schemas.account.DeleteAccountRequest("Delete account request", required=True, scope=api.Scope.BODY)

        class NoContent(api.Response):
            pass


class RenameAccount(Api.Path("/providers/{providerId}/accounts/{accountId}/_rename")):
    class Post(api.Post):
        __security__ = ctu.Restriction.TVM_SERVICE

        providerId = schemas.common.ProviderId(scope=api.Scope.PATH)
        accountId = schemas.common.AccountId(scope=api.Scope.PATH)

        data = schemas.account.RenameAccountRequest("Rename account request", required=True, scope=api.Scope.BODY)

        class Ok(api.Response):
            schema = schemas.account.Account()


class MoveAccount(Api.Path("/providers/{providerId}/accounts/{accountId}/_move")):
    class Post(api.Post):
        __security__ = ctu.Restriction.TVM_SERVICE

        providerId = schemas.common.ProviderId(scope=api.Scope.PATH)
        accountId = schemas.common.AccountId(scope=api.Scope.PATH)

        data = schemas.account.MoveAccountRequest("Move account request", required=True, scope=api.Scope.BODY)

        class Ok(api.Response):
            schema = schemas.account.Account()


class ListAccounts(Api.Path("/providers/{providerId}/accounts/_getPage")):
    class Post(api.Post):
        __security__ = ctu.Restriction.TVM_SERVICE

        providerId = schemas.common.ProviderId(scope=api.Scope.PATH)

        data = schemas.account.ListAccountsRequest("List accounts request", required=True, scope=api.Scope.BODY)

        class Ok(api.Response):
            schema = schemas.account.ListAccountsResponse()


class RevokeFreeTier(Api.Path("/providers/{providerId}/accounts/{accountId}/_revokeFreeTier")):
    class Post(api.Post):
        __security__ = ctu.Restriction.TVM_SERVICE

        providerId = schemas.common.ProviderId(scope=api.Scope.PATH)
        accountId = schemas.common.AccountId(scope=api.Scope.PATH)

        data = schemas.account.RevokeFreeTierRequest(
            "Free tier revoke request", required=True, scope=api.Scope.BODY
        )

        class Ok(api.Response):
            schema = schemas.account.Account()


class UpdateProvision(Api.Path("/providers/{providerId}/accounts/{accountId}/_provide")):
    class Post(api.Post):
        __security__ = ctu.Restriction.TVM_SERVICE

        providerId = schemas.common.ProviderId(scope=api.Scope.PATH)
        accountId = schemas.common.AccountId(scope=api.Scope.PATH)

        data = schemas.provision.UpdateProvisionRequest("Update provision request", required=True, scope=api.Scope.BODY)

        class Ok(api.Response):
            schema = schemas.provision.UpdateProvisionResponse()


class MoveProvision(Api.Path("/providers/{providerId}/accounts/{accountId}/_moveProvision")):
    class Post(api.Post):
        __security__ = ctu.Restriction.TVM_SERVICE

        providerId = schemas.common.ProviderId(scope=api.Scope.PATH)
        accountId = schemas.common.AccountId(scope=api.Scope.PATH)

        data = schemas.provision.MoveProvisionRequest("Move provision request", required=True, scope=api.Scope.BODY)

        class Ok(api.Response):
            schema = schemas.provision.MoveProvisionResponse()
