from __future__ import absolute_import

from six.moves import urllib_parse as urlparse

from sandbox.common import api as common_api
from sandbox.common import urls as common_urls

url = urlparse.urlparse(common_urls.server_url())
host = url.netloc
schemes = [url.scheme]


class Api(common_api.Api):
    swagger = "2.0"
    schemes = schemes
    host = host
    basePath = "/quotaManagement/v1"
    info = dict(
        title="Sandbox Quota Management API",
        description=(
            "API for management of quotas in Sandbox, for use by the Service D "
            "[https://wiki.yandex-team.ru/resource-model/providers/provider_iface_spec/#restapiprovajjdera]"
        ),
        contact=dict(email="sandbox@yandex-team.ru"),
        version="1"
    )
    consumes = ["application/json; charset=utf-8"]
    produces = ["application/json; charset=utf-8"]
