from __future__ import absolute_import

from sandbox.common import api
from ..api import Api

from . import common
from . import resource


class Provision(Api.Schema):
    """ Resource provision """
    resourceKey = resource.ResourceKey()
    providedAmount = api.Integer("Provided amount")
    providedAmountUnitKey = api.String("Provided amount unit key")
    allocatedAmount = api.Integer("Allocated amount")
    allocatedAmountUnitKey = api.String("Allocated amount unit key")
    lastUpdate = common.LastUpdate("Last update for this account")
    quotaVersion = api.Integer("Current version of the provision")


class ProvisionRequest(Api.Schema):
    """ New value for resource provision """
    resourceKey = resource.ResourceKey()
    providedAmount = api.Integer("Provided amount")
    providedAmountUnitKey = api.String("Provided amount unit key")


class KnownProvision(Api.Schema):
    """ Last known value of resource provision as saved in quota management """
    resourceKey = resource.ResourceKey()
    providedAmount = api.Integer("Provided amount")
    providedAmountUnitKey = api.String("Provided amount unit key")


class KnownAccountProvisions(Api.Schema):
    """ Last known value of resource provision as saved in quota management for an account """
    accountId = common.AccountId()
    knownProvisions = api.Array(
        KnownProvision,
        "Last known value of resource provision as saved in quota management for each resource in an account"
    )


class UpdateProvisionRequest(Api.Schema):
    """ Provision update request """
    folderId = common.FolderId()
    abcServiceId = common.AbcServiceId()
    updatedProvisions = api.Array(ProvisionRequest, "Updated provided amounts")
    knownProvisions = api.Array(
        KnownAccountProvisions,
        "Last known provided amounts as saved in quota management for each account in the folder"
    )
    author = common.UserId()
    operationId = common.OperationId()
    accountsSpaceKey = resource.AccountsSpaceKey()


class UpdateProvisionResponse(Api.Schema):
    """ Provision update response """
    provisions = api.Array(Provision, "Updated provisions")
    accountVersion = common.AccountVersion()
    accountsSpaceKey = resource.AccountsSpaceKey()


class MoveProvisionRequest(Api.Schema):
    """ Move provision request """
    destinationAccountId = common.AccountId("Destination account id")
    sourceFolderId = common.FolderId("Source folder id")
    destinationFolderId = common.FolderId("Destination folder id")
    sourceAbcServiceId = common.AbcServiceId("Abc service id of the source folder")
    destinationAbcServiceId = common.AbcServiceId("Abc service id of the destination folder")
    knownSourceProvisions = api.Array(
        KnownAccountProvisions,
        "Last known provided amounts as saved in quota management "
        "for all accounts in the folder of the source account"
    )
    knownDestinationProvisions = api.Array(
        KnownAccountProvisions,
        "Last known provided amounts as saved in quota management "
        "for all accounts in the folder of the destination account"
    )
    updatedSourceProvisions = api.Array(ProvisionRequest, "Updated provided amounts for source account")
    updatedDestinationProvisions = api.Array(ProvisionRequest, "Updated provided amounts for destination account")
    author = common.UserId()
    operationId = common.OperationId()
    accountsSpaceKey = resource.AccountsSpaceKey()


class MoveProvisionResponse(Api.Schema):
    """ Provision move response """
    sourceProvisions = api.Array(Provision, "Updated source provisions")
    destinationProvisions = api.Array(Provision, "Updated destination provisions")
    accountsSpaceKey = resource.AccountsSpaceKey()
    sourceAccountVersion = common.AccountVersion("Current version of the source account and its provisions")
    destinationAccountVersion = common.AccountVersion("Current version of the destination account and its provisions")
