from __future__ import absolute_import

from sandbox.common import api
from ..api import Api


class ResourceSegmentKey(Api.Schema):
    """ Resource segment key """
    segmentationKey = api.String("Resource segmentation key")
    segmentKey = api.String("Resource segment key")


Segmentation = api.Array(ResourceSegmentKey, "Resource segment keys")


class ResourceKey(Api.Schema):
    """ Resource key """
    resourceTypeKey = api.String("resourceTypeKey")
    segmentation = Segmentation()


class AccountsSpaceKey(Api.Schema):
    """ Accounts space key """
    segmentation = Segmentation()
