import httplib

import flask

from sandbox.common import statistics

from sandbox.web.api import v1
from sandbox.serviceapi.web import RouteV1


class SignalReceptor(RouteV1(v1.statistics.ServiceStatisticsAPI)):
    @classmethod
    def post(cls, signal_type, body):
        """
        Save a signal or a batch of signals of arbitrary structure into intermediate MongoDB collection.
        All times are read as UTC ones

        :type signal_type: str
        :type body: list[dict]
        """

        for item in body:
            item[statistics.Signaler.TYPE_KEY] = signal_type

        statistics.Signaler().push(body)

        return flask.current_app.response_class(
            status=httplib.CREATED,
        )
