import flask

from sandbox.web.api import v1


class NotificationMapperBase(object):
    @property
    def base_url(self):
        return flask.request.base_url.rsplit("/", 1)[0]

    @staticmethod
    def base_fields(doc):
        return {
            "id": str(doc.id),
            "created": doc.date,
            "recipients": doc.send_to,
            "subject": doc.subject,
            "transport": doc.transport,
            "type": doc.type,
            "sent": doc.sent,
            "task_id": doc.task_id,
            "urgent": doc.urgent,
        }


class NotificationListItemMapper(NotificationMapperBase):
    def dump(self, doc):
        return v1.schemas.notification.NotificationListItem.create(
            url="{}/{}".format(self.base_url, doc.id),
            **self.base_fields(doc)
        )


class NotificationMapper(NotificationMapperBase):
    def dump(self, doc):
        return v1.schemas.notification.NotificationItem.create(
            author=doc.author,
            body=doc.body,
            host=doc.host,
            headers=doc.headers,
            charset=doc.charset,
            view=doc.view,
            inconsistent=doc.inconsistent,
            check_status=doc.check_status,
            juggler_tags=doc.juggler_tags,
            **self.base_fields(doc)
        )
