import urllib

from sandbox import common
from sandbox.web.api import v1
from sandbox.yasandbox import context, controller


class SemaphoreListItemMapper(object):
    @classmethod
    def _base_url(cls):
        return context.current.request.base_url

    @classmethod
    def _response_parameters(cls, doc, value, groups):
        return {
            "id": doc.id,
            "rights": controller.Semaphore.rights(context.current.request.user, doc, groups),
            "name": doc.name,
            "owner": doc.owner,
            "url": "{}/{}".format(context.current.request.base_url, doc.id),
            "shared": doc.shared,
            "capacity": doc.capacity,
            "value": value,
            "auto": doc.auto,
            "public": doc.public,
            "time": dict(
                created=doc.time.created,
                updated=doc.time.updated
            )
        }

    @classmethod
    def list_dump(cls, doc, value, groups):
        return v1.schemas.semaphore.SemaphoreListItem.create(
            **cls._response_parameters(doc, value, groups)
        )

    @classmethod
    def dump(cls, doc, value, groups):
        fields = cls._response_parameters(doc, value, groups)
        tasks = controller.TaskQueue.qclient.semaphore_tasks(doc.id)
        fields["tasks"] = [{"task_id": task_weight[0], "weight": task_weight[1]} for task_weight in tasks]
        settings = common.config.Registry().server.solomon
        solomon_settings = {
            "project": settings.push.project,
            "cluster": settings.push.cluster,
            "service": settings.push.service,
            "type": "semaphore_capacity|semaphore_value|semaphore_blocked",
            "sensor": doc.name
        }
        if all(solomon_settings.itervalues()):
            fields["statistics_url"] = "{}?{}".format(settings.url, urllib.urlencode(solomon_settings))
        return v1.schemas.semaphore.Semaphore.create(
            **fields
        )


class SemaphoreMapper(SemaphoreListItemMapper):
    @classmethod
    def _base_url(cls):
        return context.current.request.base_url.rsplit("/", 1)[0]
