import sandbox.common.types.user as ctu

from sandbox.web.api import v1

from sandbox.yasandbox import controller


class VaultMapper(object):
    @classmethod
    def rights(cls, context, vault, groups_and_login):
        if (
            (context.current.user.super_user and not context.current.user.robot) or
            (groups_and_login and vault.owner in groups_and_login)
        ):
            return ctu.Rights.WRITE
        elif vault.allowed_users and any(g_or_l in vault.allowed_users for g_or_l in groups_and_login):
            return ctu.Rights.READ
        return None

    @classmethod
    def dump_list_item(cls, context, vault, groups_and_login, url):
        return v1.vault.schemas.vault.VaultListItem.create(
            id=vault.id,
            rights=cls.rights(context, vault, groups_and_login),
            name=vault.name,
            owner=vault.owner,
            url=url,
            shared=vault.allowed_users,
            description=vault.description,
        )

    @classmethod
    def dump(cls, context, vault, groups_and_login, url):
        return v1.vault.schemas.vault.Vault.create(
            id=vault.id,
            rights=cls.rights(context, vault, groups_and_login),
            name=vault.name,
            owner=vault.owner,
            url=url,
            shared=vault.allowed_users,
            description=vault.description,
            data_length=controller.Vault.data_length(vault.data)
        )
