from sandbox.serviceapi.mules import metrics


__all__ = ("rate_inc", "rate_dec", "Histogram")


def rate_inc(name, labels={}):
    metrics.send_msg(metrics.Sensor.Op.INC, (name, labels, metrics.Sensor.Kind.RATE))


def rate_dec(name, labels={}):
    metrics.send_msg(metrics.Sensor.Op.DEC, (name, labels, metrics.Sensor.Kind.RATE))


def gauge_inc(name, labels={}):
    metrics.send_msg(metrics.Sensor.Op.INC, (name, labels, metrics.Sensor.Kind.DGAUGE))


def gauge_dec(name, labels={}):
    metrics.send_msg(metrics.Sensor.Op.DEC, (name, labels, metrics.Sensor.Kind.DGAUGE))


class Histogram(object):
    def __init__(self, name, buckets, base=2):
        self.name = name
        self.buckets = [base**i for i in range(1, buckets)]

    def record(self, duration):
        for bucket in self.buckets:
            if duration < bucket:
                rate_inc(self.name, {"bucket": "{} ms".format(bucket)})
                break
