import logging

try:
    import uwsgi
except ImportError:
    uwsgi = None


__all__ = ("setup_mule_logging",)


class UwsgiLogHandler(logging.Handler):
    def emit(self, record):
        uwsgi.log(self.format(record))


def setup_mule_logging():
    handler = UwsgiLogHandler()
    handler.setFormatter(logging.Formatter("%(levelname)-7s (%(pathname)s:%(lineno)s) %(message)s"))

    logging.root.handlers = []  # Somebody could have already initialized logging
    logging.root.addHandler(handler)
    logging.root.setLevel(logging.DEBUG)
