import logging
import cPickle as pickle

import sandbox.common.types.misc as ctm

from sandbox.common import config
from sandbox.common import statistics

from sandbox.serviceapi import mules

from sandbox.yasandbox.database import mapping


__all__ = ("send_msg", "run_safe")


logger = logging.getLogger(__name__)

registry = config.Registry()


def send_msg(msg):
    import uwsgi
    uwsgi.mule_msg(pickle.dumps(msg), 1)


def run():
    import uwsgi
    mapping.ensure_connection()
    logger.info("Start Signaler mule")

    signaler = statistics.Signaler(
        statistics.UASignalHandlerServiceApi(),
        statistics.UASignalHandlerServiceApiCalls(),
        statistics.UASignalHandlerResourceAudit(),
        component=ctm.Component.SERVICEAPI,
        update_interval=registry.server.statistics.update_interval,
    )

    while True:
        try:
            message = pickle.loads(uwsgi.mule_get_msg())
        except Exception:
            logger.exception("Got exception on signaler mule. Skip message")
            continue

        signaler.push(message)


def run_safe():
    mules.setup_mule_logging()

    try:
        run()
    except:
        logger.exception("Got exception in mule!")
        raise
